/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.mongodb;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.instrument.mongodb.BasicUserRepository;
import org.springframework.cloud.sleuth.instrument.mongodb.User;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.test.context.DynamicPropertySource;
import org.testcontainers.containers.MongoDBContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;
import org.testcontainers.utility.DockerImageName;
import reactor.core.publisher.Mono;

@ContextConfiguration(classes={TestConfig.class})
@Testcontainers
@Tag(value="DockerRequired")
public abstract class ReactiveMongoDbIntegrationTests {
    private static final Log log = LogFactory.getLog(ReactiveMongoDbIntegrationTests.class);
    @Autowired
    TestSpanHandler spans;
    @Autowired
    Tracer tracer;
    @Autowired
    BasicUserRepository basicUserRepository;
    @Container
    static MongoDBContainer mongoDBContainer = new MongoDBContainer(DockerImageName.parse((String)"mongo").withTag("4.4.7"));

    @DynamicPropertySource
    static void setProperties(DynamicPropertyRegistry registry) {
        mongoDBContainer.start();
        registry.add("spring.data.mongodb.uri", () -> ((MongoDBContainer)mongoDBContainer).getReplicaSetUrl());
    }

    @BeforeEach
    void setup() {
        this.spans.clear();
    }

    @Test
    public void should_pass_tracing_information_when_using_reactive_mongodb() {
        Span nextSpan = this.tracer.nextSpan().name("mongo-reactive-app");
        Mono.just((Object)nextSpan).doOnNext(span -> this.tracer.withSpan(nextSpan.start())).flatMap(span -> {
            log.info((Object)"Hello from flat map");
            return this.basicUserRepository.save(new User("foo", "bar", "baz", null)).flatMap(user -> this.basicUserRepository.findUserByUsername("foo"));
        }).contextWrite(context -> context.put(Span.class, (Object)nextSpan).put(TraceContext.class, (Object)nextSpan.context())).doFinally(signalType -> nextSpan.end()).block(Duration.ofMinutes(1L));
        List<FinishedSpan> reportedSpans = this.spans.reportedSpans();
        ((AbstractCollectionAssert)BDDAssertions.then((Collection)reportedSpans.stream().map(FinishedSpan::getTraceId).collect(Collectors.toSet())).as("There must be only 1 trace id", new Object[0])).hasSize(1);
        List mongoSpanNames = reportedSpans.stream().filter(fs -> fs.getName().equals("insert user") || fs.getName().equals("find user")).map(FinishedSpan::getName).collect(Collectors.toList());
        ((ListAssert)BDDAssertions.then(mongoSpanNames).as("There must be first an insert then a find", new Object[0])).containsExactly((Object[])new String[]{"insert user", "find user"});
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    public static class TestConfig {
    }
}

