/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.presentation.StandardRepresentation;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.cloud.sleuth.instrument.reactor.ScopePassingSpanSubscriber;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import reactor.core.publisher.Hooks;
import reactor.core.scheduler.Schedulers;
import reactor.util.concurrent.Queues;

public abstract class QueueWrapperTests {
    AnnotationConfigApplicationContext springContext = new AnnotationConfigApplicationContext();

    protected abstract CurrentTraceContext currentTraceContext();

    protected abstract TraceContext context();

    @BeforeEach
    public void setup() {
        Hooks.removeQueueWrappers();
        Hooks.resetOnLastOperator();
        Schedulers.resetOnScheduleHooks();
    }

    @AfterEach
    public void close() {
        this.springContext.close();
        Hooks.removeQueueWrappers();
        Hooks.resetOnLastOperator();
        Schedulers.resetOnScheduleHooks();
    }

    @Test
    void checkContextIsRestoredAndOnNullCleaned() {
        TraceContext context;
        this.springContext.registerBean(CurrentTraceContext.class, this::currentTraceContext, new BeanDefinitionCustomizer[0]);
        this.springContext.refresh();
        Queue queue = ReactorSleuth.traceQueue((ConfigurableApplicationContext)this.springContext, (Queue)((Queue)Queues.get((int)128).get()));
        try (CurrentTraceContext.Scope ws = this.currentTraceContext().newScope(this.context());){
            context = this.currentTraceContext().context();
            queue.offer(1);
        }
        Assertions.assertThat(queue.poll()).isEqualTo((Object)1);
        ((ObjectAssert)Assertions.assertThat((Object)this.currentTraceContext().context()).isNotNull()).isEqualTo((Object)context);
        Assertions.assertThat(queue.poll()).isNull();
        Assertions.assertThat((Object)this.currentTraceContext().context()).isNull();
    }

    @Test
    void checkContextIsNotCleanOnNullCleanedIfContextWasAvailableOnThread() {
        this.springContext.registerBean(CurrentTraceContext.class, this::currentTraceContext, new BeanDefinitionCustomizer[0]);
        this.springContext.refresh();
        Queue queue = ReactorSleuth.traceQueue((ConfigurableApplicationContext)this.springContext, (Queue)((Queue)Queues.get((int)128).get()));
        CurrentTraceContext.Scope ws = this.currentTraceContext().newScope(this.context());
        TraceContext context = this.currentTraceContext().context();
        queue.offer(1);
        Assertions.assertThat(queue.poll()).isEqualTo((Object)1);
        ((ObjectAssert)Assertions.assertThat((Object)this.currentTraceContext().context()).isNotNull()).isEqualTo((Object)context);
        Assertions.assertThat(queue.poll()).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.currentTraceContext().context()).isNotNull()).isEqualTo((Object)context);
        ws.close();
        Assertions.assertThat((Object)this.currentTraceContext().context()).isNull();
    }

    @Test
    void checkContextIsRestoredAndOnNullCleanedInCaseOfSubsequentPolls() {
        TraceContext context;
        this.springContext.registerBean(CurrentTraceContext.class, this::currentTraceContext, new BeanDefinitionCustomizer[0]);
        this.springContext.refresh();
        Queue queue = ReactorSleuth.traceQueue((ConfigurableApplicationContext)this.springContext, (Queue)((Queue)Queues.get((int)128).get()));
        try (CurrentTraceContext.Scope ws = this.currentTraceContext().newScope(this.context());){
            context = this.currentTraceContext().context();
            queue.offer(1);
            queue.offer(2);
        }
        Assertions.assertThat(queue.poll()).isEqualTo((Object)1);
        ((ObjectAssert)Assertions.assertThat((Object)this.currentTraceContext().context()).isNotNull()).isEqualTo((Object)context);
        Assertions.assertThat(queue.poll()).isEqualTo((Object)2);
        ((ObjectAssert)Assertions.assertThat((Object)this.currentTraceContext().context()).isNotNull()).isEqualTo((Object)context);
        Assertions.assertThat(queue.poll()).isNull();
        Assertions.assertThat((Object)this.currentTraceContext().context()).isNull();
    }

    @Test
    void checkContextIsRestoredAndOnNullCleanedInCaseOfSubsequentPollsByAnotherThread() throws InterruptedException {
        TraceContext context;
        this.springContext.registerBean(CurrentTraceContext.class, this::currentTraceContext, new BeanDefinitionCustomizer[0]);
        this.springContext.refresh();
        Queue queue = ReactorSleuth.traceQueue((ConfigurableApplicationContext)this.springContext, (Queue)((Queue)Queues.get((int)128).get()));
        try (CurrentTraceContext.Scope ws = this.currentTraceContext().newScope(this.context());){
            context = this.currentTraceContext().context();
            queue.offer(1);
            queue.offer(2);
        }
        Assertions.assertThat(queue.poll()).isEqualTo((Object)1);
        ((ObjectAssert)Assertions.assertThat((Object)this.currentTraceContext().context()).isNotNull()).isEqualTo((Object)context);
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> {
            Assertions.assertThat(queue.poll()).isEqualTo((Object)2);
            ((ObjectAssert)Assertions.assertThat((Object)this.currentTraceContext().context()).isNotNull()).isEqualTo((Object)context);
            Assertions.assertThat(queue.poll()).isNull();
            Assertions.assertThat((Object)this.currentTraceContext().context()).isNull();
            latch.countDown();
        }).start();
        Assertions.assertThat((boolean)latch.await(10L, TimeUnit.SECONDS)).isTrue();
        Assertions.assertThat(queue.poll()).isNull();
        Assertions.assertThat((Object)this.currentTraceContext().context()).isNull();
    }

    @Test
    void checkContextIsNotCleanOnNullCleanedIfContextWasAvailableOnThreadAnotherThreadCase() throws InterruptedException {
        TraceContext context;
        this.springContext.registerBean(CurrentTraceContext.class, this::currentTraceContext, new BeanDefinitionCustomizer[0]);
        this.springContext.refresh();
        Queue queue = ReactorSleuth.traceQueue((ConfigurableApplicationContext)this.springContext, (Queue)((Queue)Queues.get((int)128).get()));
        try (CurrentTraceContext.Scope ws = this.currentTraceContext().newScope(this.context());){
            context = this.currentTraceContext().context();
            queue.offer(1);
            queue.offer(2);
        }
        Assertions.assertThat(queue.poll()).isEqualTo((Object)1);
        ((ObjectAssert)Assertions.assertThat((Object)this.currentTraceContext().context()).isNotNull()).isEqualTo((Object)context);
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> {
            CurrentTraceContext.Scope ws = this.currentTraceContext().maybeScope(context);
            Assertions.assertThat(queue.poll()).isEqualTo((Object)2);
            ((ObjectAssert)Assertions.assertThat((Object)this.currentTraceContext().context()).isNotNull()).isEqualTo((Object)context);
            Assertions.assertThat(queue.poll()).isNull();
            ((ObjectAssert)Assertions.assertThat((Object)this.currentTraceContext().context()).isNotNull()).isEqualTo((Object)context);
            ws.close();
            Assertions.assertThat((Object)this.currentTraceContext().context()).isNull();
            latch.countDown();
        }).start();
        Assertions.assertThat((boolean)latch.await(10L, TimeUnit.SECONDS)).isTrue();
        Assertions.assertThat(queue.poll()).isNull();
        Assertions.assertThat((Object)this.currentTraceContext().context()).isNull();
    }

    @Test
    void checkContextIsNotCleanOnNullCleanedIfContextWasAvailableOnThreadAnotherThreadCase2() throws InterruptedException {
        this.springContext.registerBean(CurrentTraceContext.class, this::currentTraceContext, new BeanDefinitionCustomizer[0]);
        this.springContext.refresh();
        Queue queue = ReactorSleuth.traceQueue((ConfigurableApplicationContext)this.springContext, (Queue)((Queue)Queues.get((int)128).get()));
        CurrentTraceContext.Scope ws1 = this.currentTraceContext().newScope(this.context());
        TraceContext context = this.currentTraceContext().context();
        queue.offer(1);
        queue.offer(2);
        Assertions.assertThat(queue.poll()).isEqualTo((Object)1);
        ((ObjectAssert)Assertions.assertThat((Object)this.currentTraceContext().context()).isNotNull()).isEqualTo((Object)context);
        ws1.close();
        Assertions.assertThat((Object)this.currentTraceContext().context()).isNull();
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> {
            Assertions.assertThat(queue.poll()).isEqualTo((Object)2);
            ((ObjectAssert)Assertions.assertThat((Object)this.currentTraceContext().context()).isNotNull()).isEqualTo((Object)context);
            Assertions.assertThat(queue.poll()).isNull();
            Assertions.assertThat((Object)this.currentTraceContext().context()).isNull();
            latch.countDown();
        }).start();
        Assertions.assertThat((boolean)latch.await(10L, TimeUnit.SECONDS)).isTrue();
        Assertions.assertThat(queue.poll()).isNull();
        Assertions.assertThat((Object)this.currentTraceContext().context()).isNull();
    }

    static {
        StandardRepresentation.registerFormatterForType(ScopePassingSpanSubscriber.class, Objects::toString);
    }
}

