/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.BDDAssertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceExecutor;
import org.springframework.cloud.sleuth.instrument.web.client.CustomAsyncClientHttpRequestFactory;
import org.springframework.cloud.sleuth.instrument.web.client.CustomClientHttpRequestFactory;
import org.springframework.cloud.sleuth.instrument.web.client.MyRestController;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.web.client.AsyncRestTemplate;

@ContextConfiguration(classes={TestConfig.class, CustomExecutorConfig.class, ControllerConfig.class})
@DirtiesContext
public abstract class MultipleAsyncRestTemplateTests {
    private static final Log log = LogFactory.getLog(MultipleAsyncRestTemplateTests.class);
    @Autowired
    @Qualifier(value="customAsyncRestTemplate")
    AsyncRestTemplate asyncRestTemplate;
    @Autowired
    AsyncConfigurer executor;
    Executor wrappedExecutor;
    @Autowired
    Tracer tracer;
    @LocalServerPort
    int port;

    @BeforeEach
    public void setup() {
        this.wrappedExecutor = this.executor.getAsyncExecutor();
    }

    @Test
    public void should_start_context_with_custom_async_client() throws Exception {
        BDDAssertions.then((Object)this.asyncRestTemplate).isNotNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_pass_tracing_context_with_custom_async_client() throws Exception {
        Span span = this.tracer.nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            String result = (String)((ResponseEntity)this.asyncRestTemplate.getForEntity("http://localhost:" + this.port + "/foo", String.class, new Object[0]).get()).getBody();
            BDDAssertions.then((String)span.context().traceId()).isEqualTo(result);
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    @Test
    public void should_start_context_with_custom_executor() throws Exception {
        BDDAssertions.then((Object)this.executor).isNotNull();
        BDDAssertions.then((Object)this.wrappedExecutor).isInstanceOf(LazyTraceExecutor.class);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_inject_traced_executor_that_passes_tracing_context() throws Exception {
        Span span = this.tracer.nextSpan().name("foo");
        AtomicBoolean executed = new AtomicBoolean(false);
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            this.wrappedExecutor.execute(() -> {
                Span currentSpan = this.tracer.currentSpan();
                log.info((Object)("Current span " + currentSpan));
                BDDAssertions.then((Object)currentSpan).isNotNull();
                String currentTraceId = currentSpan.context().traceId();
                String initialTraceId = span.context().traceId();
                log.info((Object)("Hello from runnable before trace id check. Initial [" + initialTraceId + "] current [" + currentTraceId + "]"));
                BDDAssertions.then((String)currentTraceId).isEqualTo(initialTraceId);
                executed.set(true);
                log.info((Object)"Hello from runnable");
            });
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    @Configuration(proxyBeanMethods=false)
    public static class ControllerConfig {
        @Bean
        MyRestController myRestController(Tracer tracer) {
            return new MyRestController(tracer);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    @EnableAsync
    @Role(value=2)
    public static class CustomExecutorConfig
    extends AsyncConfigurerSupport {
        @Autowired
        BeanFactory beanFactory;

        public Executor getAsyncExecutor() {
            ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
            executor.setCorePoolSize(7);
            executor.setMaxPoolSize(42);
            executor.setQueueCapacity(11);
            executor.setThreadNamePrefix("MyExecutor-");
            executor.initialize();
            return new LazyTraceExecutor(this.beanFactory, (Executor)executor);
        }
    }

    @EnableAutoConfiguration
    @Configuration(proxyBeanMethods=false)
    public static class TestConfig {
        @Bean(name={"customAsyncRestTemplate"})
        public AsyncRestTemplate traceAsyncRestTemplate() {
            return new AsyncRestTemplate(this.asyncClientFactory(), this.clientHttpRequestFactory());
        }

        private ClientHttpRequestFactory clientHttpRequestFactory() {
            CustomClientHttpRequestFactory clientHttpRequestFactory = new CustomClientHttpRequestFactory();
            return clientHttpRequestFactory;
        }

        private AsyncClientHttpRequestFactory asyncClientFactory() {
            CustomAsyncClientHttpRequestFactory factory = new CustomAsyncClientHttpRequestFactory();
            return factory;
        }
    }
}

