/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.metric.SpanMetricReporter;
import org.springframework.cloud.sleuth.zipkin.ZipkinSpanReporter;
import zipkin.Codec;
import zipkin.Span;

public final class HttpZipkinSpanReporter
implements ZipkinSpanReporter,
Flushable,
Closeable {
    private static final Log log = LogFactory.getLog(HttpZipkinSpanReporter.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final String url;
    private final BlockingQueue<Span> pending = new LinkedBlockingQueue<Span>(1000);
    private final Flusher flusher;
    private final boolean compressionEnabled;
    private final SpanMetricReporter spanMetricReporter;

    public HttpZipkinSpanReporter(String baseUrl, int flushInterval, boolean compressionEnabled, SpanMetricReporter spanMetricReporter) {
        this.url = baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "api/v1/spans";
        this.flusher = flushInterval > 0 ? new Flusher(this, flushInterval) : null;
        this.compressionEnabled = compressionEnabled;
        this.spanMetricReporter = spanMetricReporter;
    }

    @Override
    public void report(Span span) {
        this.spanMetricReporter.incrementAcceptedSpans(1L);
        if (!this.pending.offer(span)) {
            this.spanMetricReporter.incrementDroppedSpans(1L);
        }
    }

    @Override
    public void flush() {
        if (this.pending.isEmpty()) {
            return;
        }
        ArrayList drained = new ArrayList(this.pending.size());
        this.pending.drainTo(drained);
        if (drained.isEmpty()) {
            return;
        }
        byte[] json = Codec.JSON.writeSpans(drained);
        if (json == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("failed to encode spans, dropping them: " + drained));
            }
            this.spanMetricReporter.incrementDroppedSpans((long)drained.size());
            return;
        }
        try {
            this.postSpans(json);
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("error POSTing spans to " + this.url + ": as json: " + new String(json, UTF_8)), (Throwable)e);
            }
            this.spanMetricReporter.incrementDroppedSpans((long)drained.size());
        }
    }

    void postSpans(byte[] json) throws IOException {
        Throwable throwable;
        Object compressor;
        HttpURLConnection connection = (HttpURLConnection)new URL(this.url).openConnection();
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Content-Type", "application/json");
        if (this.compressionEnabled) {
            connection.addRequestProperty("Content-Encoding", "gzip");
            ByteArrayOutputStream gzipped = new ByteArrayOutputStream();
            compressor = new GZIPOutputStream(gzipped);
            throwable = null;
            try {
                ((FilterOutputStream)compressor).write(json);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (compressor != null) {
                    if (throwable != null) {
                        try {
                            ((DeflaterOutputStream)compressor).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((DeflaterOutputStream)compressor).close();
                    }
                }
            }
            json = gzipped.toByteArray();
        }
        connection.setDoOutput(true);
        connection.setFixedLengthStreamingMode(json.length);
        connection.getOutputStream().write(json);
        try {
            InputStream in = connection.getInputStream();
            compressor = null;
            try {
                while (in.read() != -1) {
                }
            }
            catch (Throwable throwable4) {
                compressor = throwable4;
                throw throwable4;
            }
            finally {
                if (in != null) {
                    if (compressor != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable5) {
                            ((Throwable)compressor).addSuppressed(throwable5);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throwable = null;
            try (InputStream err = connection.getErrorStream();){
                if (err != null) {
                    while (err.read() != -1) {
                    }
                }
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            throw e;
        }
    }

    @Override
    public void close() {
        if (this.flusher != null) {
            this.flusher.scheduler.shutdown();
        }
        int dropped = this.pending.drainTo(new LinkedList());
        this.spanMetricReporter.incrementDroppedSpans((long)dropped);
    }

    static final class Flusher
    implements Runnable {
        final Flushable flushable;
        final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

        Flusher(Flushable flushable, int flushInterval) {
            this.flushable = flushable;
            this.scheduler.scheduleWithFixedDelay(this, 0L, flushInterval, TimeUnit.SECONDS);
        }

        @Override
        public void run() {
            try {
                this.flushable.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

