/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.autoconfigure.secretsmanager;

import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.aws.secretsmanager.AwsSecretsManagerProperties;
import org.springframework.cloud.aws.secretsmanager.AwsSecretsManagerPropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={AwsSecretsManagerProperties.class})
@ConditionalOnClass(value={AWSSecretsManager.class, AwsSecretsManagerPropertySourceLocator.class})
@ConditionalOnProperty(prefix="aws.secretsmanager", name={"enabled"}, matchIfMissing=true)
public class AwsSecretsManagerBootstrapConfiguration {
    @Bean
    AwsSecretsManagerPropertySourceLocator awsSecretsManagerPropertySourceLocator(AWSSecretsManager smClient, AwsSecretsManagerProperties properties) {
        return new AwsSecretsManagerPropertySourceLocator(smClient, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    AWSSecretsManager smClient() {
        return AWSSecretsManagerClientBuilder.defaultClient();
    }
}

