/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.reactorkafka;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.cloud.stream.binder.kafka.common.AbstractKafkaBinderHealthIndicator;
import org.springframework.cloud.stream.binder.kafka.common.TopicInformation;
import org.springframework.cloud.stream.binder.reactorkafka.ReactorKafkaBinder;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

@Deprecated(since="4.3", forRemoval=true)
public class ReactorKafkaBinderHealthIndicator
extends AbstractKafkaBinderHealthIndicator {
    private final ReactorKafkaBinder binder;

    public ReactorKafkaBinderHealthIndicator(ReactorKafkaBinder binder, ConsumerFactory<?, ?> consumerFactory) {
        super(consumerFactory);
        this.binder = binder;
    }

    protected ExecutorService createHealthBinderExecutorService() {
        return Executors.newSingleThreadExecutor((ThreadFactory)new CustomizableThreadFactory("reactor-kafka-binder-health-"));
    }

    protected Map<String, TopicInformation> getTopicsInUse() {
        return this.binder.getTopicsInUse();
    }

    protected Health buildBinderSpecificHealthDetails() {
        Map<String, MessageProducerSupport> messageProducerSupportInfo = this.binder.getMessageProducers();
        if (messageProducerSupportInfo.isEmpty()) {
            return Health.unknown().build();
        }
        Status status = Status.UP;
        ArrayList messageProducers = new ArrayList();
        HashMap<String, Object> messageProducerDetails = new HashMap<String, Object>();
        for (String groupId : messageProducerSupportInfo.keySet()) {
            MessageProducerSupport messageProducerSupport = messageProducerSupportInfo.get(groupId);
            boolean isRunning = messageProducerSupport.isRunning();
            boolean isOk = messageProducerSupport.isActive();
            if (!isOk) {
                status = Status.DOWN;
            }
            messageProducerDetails.put("isRunning", isRunning);
            messageProducerDetails.put("isStoppedAbnormally", !isRunning && !isOk);
            messageProducerDetails.put("messageProducerId", messageProducerSupport.getApplicationContextId());
            messageProducerDetails.put("groupId", groupId);
        }
        messageProducers.add(messageProducerDetails);
        return Health.status((Status)status).withDetail("messageProducers", messageProducers).build();
    }
}

