/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams.function;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.cloud.stream.binder.kafka.streams.function.KafkaStreamsBindableProxyFactory;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;

public class KafkaStreamsFunctionBeanPostProcessor
implements InitializingBean,
BeanFactoryAware {
    private static final Log LOG = LogFactory.getLog(KafkaStreamsFunctionBeanPostProcessor.class);
    private static final String[] EXCLUDE_FUNCTIONS = new String[]{"functionRouter", "sendToDlqAndContinue"};
    private ConfigurableListableBeanFactory beanFactory;
    private boolean onlySingleFunction;
    private Map<String, ResolvableType> resolvableTypeMap = new TreeMap<String, ResolvableType>();
    private final StreamFunctionProperties streamFunctionProperties;

    public KafkaStreamsFunctionBeanPostProcessor(StreamFunctionProperties streamFunctionProperties) {
        this.streamFunctionProperties = streamFunctionProperties;
    }

    public Map<String, ResolvableType> getResolvableTypes() {
        return this.resolvableTypeMap;
    }

    public void afterPropertiesSet() {
        String[] functionNames = this.beanFactory.getBeanNamesForType(Function.class);
        String[] biFunctionNames = this.beanFactory.getBeanNamesForType(BiFunction.class);
        String[] consumerNames = this.beanFactory.getBeanNamesForType(Consumer.class);
        String[] biConsumerNames = this.beanFactory.getBeanNamesForType(BiConsumer.class);
        Stream<String> concat = Stream.concat(Stream.concat(Stream.of(functionNames), Stream.of(consumerNames)), Stream.concat(Stream.of(biFunctionNames), Stream.of(biConsumerNames)));
        List collect = concat.collect(Collectors.toList());
        collect.removeIf(s -> Arrays.stream(EXCLUDE_FUNCTIONS).anyMatch(t -> t.equals(s)));
        this.onlySingleFunction = collect.size() == 1;
        collect.stream().forEach(this::extractResolvableTypes);
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.beanFactory;
        for (String s2 : this.getResolvableTypes().keySet()) {
            RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(KafkaStreamsBindableProxyFactory.class);
            rootBeanDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)this.getResolvableTypes().get(s2));
            rootBeanDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)s2);
            registry.registerBeanDefinition("kafkaStreamsBindableProxyFactory-" + s2, (BeanDefinition)rootBeanDefinition);
        }
    }

    private void extractResolvableTypes(String key) {
        Class classObj = ClassUtils.resolveClassName((String)((AnnotatedBeanDefinition)this.beanFactory.getBeanDefinition(key)).getMetadata().getClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
        try {
            Method method;
            ResolvableType resolvableType;
            Class rawClass;
            Method[] methods = classObj.getMethods();
            Optional<Method> kafkaStreamMethod = Arrays.stream(methods).filter(m -> m.getName().equals(key)).findFirst();
            if (kafkaStreamMethod.isPresent() && ((rawClass = (resolvableType = ResolvableType.forMethodReturnType((Method)(method = kafkaStreamMethod.get()), (Class)classObj)).getGeneric(new int[]{0}).getRawClass()) == KStream.class || rawClass == KTable.class || rawClass == GlobalKTable.class)) {
                if (this.onlySingleFunction) {
                    this.resolvableTypeMap.put(key, resolvableType);
                } else {
                    String definition = this.streamFunctionProperties.getDefinition();
                    if (definition == null) {
                        throw new IllegalStateException("Multiple functions found, but function definition property is not set.");
                    }
                    if (definition.contains(key)) {
                        this.resolvableTypeMap.put(key, resolvableType);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Function activation issues while mapping the function: " + key), (Throwable)e);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }
}

