/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.streams.errors.StreamsUncaughtExceptionHandler;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBinderMetrics;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBindingInformationCatalogue;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsRegistry;
import org.springframework.context.SmartLifecycle;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.streams.KafkaStreamsMicrometerListener;

public class StreamsBuilderFactoryManager
implements SmartLifecycle {
    private final KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue;
    private final KafkaStreamsRegistry kafkaStreamsRegistry;
    private final KafkaStreamsBinderMetrics kafkaStreamsBinderMetrics;
    private final KafkaStreamsMicrometerListener listener;
    private volatile boolean running;
    private final KafkaProperties kafkaProperties;

    StreamsBuilderFactoryManager(KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue, KafkaStreamsRegistry kafkaStreamsRegistry, KafkaStreamsBinderMetrics kafkaStreamsBinderMetrics, KafkaStreamsMicrometerListener listener, KafkaProperties kafkaProperties) {
        this.kafkaStreamsBindingInformationCatalogue = kafkaStreamsBindingInformationCatalogue;
        this.kafkaStreamsRegistry = kafkaStreamsRegistry;
        this.kafkaStreamsBinderMetrics = kafkaStreamsBinderMetrics;
        this.listener = listener;
        this.kafkaProperties = kafkaProperties;
    }

    public boolean isAutoStartup() {
        return this.kafkaProperties == null || this.kafkaProperties.getStreams().isAutoStartup();
    }

    public void stop(Runnable callback) {
        this.stop();
        if (callback != null) {
            callback.run();
        }
    }

    public synchronized void start() {
        if (!this.running) {
            try {
                Set<StreamsBuilderFactoryBean> streamsBuilderFactoryBeans = this.kafkaStreamsBindingInformationCatalogue.getStreamsBuilderFactoryBeans();
                for (StreamsBuilderFactoryBean streamsBuilderFactoryBean : streamsBuilderFactoryBeans) {
                    if (this.listener != null) {
                        streamsBuilderFactoryBean.addListener((StreamsBuilderFactoryBean.Listener)this.listener);
                    }
                    streamsBuilderFactoryBean.setStreamsUncaughtExceptionHandler(exception -> StreamsUncaughtExceptionHandler.StreamThreadExceptionResponse.SHUTDOWN_CLIENT);
                    Map<StreamsBuilderFactoryBean, List<ConsumerProperties>> bindingServicePropertiesPerSbfb = this.kafkaStreamsBindingInformationCatalogue.getConsumerPropertiesPerSbfb();
                    List<ConsumerProperties> consumerProperties = bindingServicePropertiesPerSbfb.get(streamsBuilderFactoryBean);
                    boolean autoStartupDisabledOnAtLeastOneConsumerBinding = consumerProperties.stream().anyMatch(consumerProperties1 -> !consumerProperties1.isAutoStartup());
                    if (autoStartupDisabledOnAtLeastOneConsumerBinding) continue;
                    streamsBuilderFactoryBean.start();
                    this.kafkaStreamsRegistry.registerKafkaStreams(streamsBuilderFactoryBean);
                }
                if (this.kafkaStreamsBinderMetrics != null) {
                    this.kafkaStreamsBinderMetrics.addMetrics(streamsBuilderFactoryBeans);
                }
                this.running = true;
            }
            catch (Exception ex) {
                throw new KafkaException("Could not start stream: ", (Throwable)ex);
            }
        }
    }

    public synchronized void stop() {
        if (this.running) {
            try {
                Set<StreamsBuilderFactoryBean> streamsBuilderFactoryBeans = this.kafkaStreamsBindingInformationCatalogue.getStreamsBuilderFactoryBeans();
                boolean n = false;
                for (StreamsBuilderFactoryBean streamsBuilderFactoryBean : streamsBuilderFactoryBeans) {
                    streamsBuilderFactoryBean.removeListener((StreamsBuilderFactoryBean.Listener)this.listener);
                    streamsBuilderFactoryBean.stop();
                }
                for (ProducerFactory producerFactory : this.kafkaStreamsBindingInformationCatalogue.getDlqProducerFactories()) {
                    ((DisposableBean)producerFactory).destroy();
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
            finally {
                this.running = false;
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 2147483547;
    }
}

