/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams.function;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBinderUtils;
import org.springframework.cloud.stream.binder.kafka.streams.function.KafkaStreamsBindableProxyFactory;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;

public class KafkaStreamsFunctionBeanPostProcessor
implements InitializingBean,
BeanFactoryAware {
    private static final Log LOG = LogFactory.getLog(KafkaStreamsFunctionBeanPostProcessor.class);
    private static final String[] EXCLUDE_FUNCTIONS = new String[]{"functionRouter", "sendToDlqAndContinue"};
    private ConfigurableListableBeanFactory beanFactory;
    private boolean onlySingleFunction;
    private final Map<String, ResolvableType> resolvableTypeMap = new TreeMap<String, ResolvableType>();
    private final Map<String, Method> methods = new TreeMap<String, Method>();
    private final StreamFunctionProperties streamFunctionProperties;
    private final Map<String, ResolvableType> kafkaStreamsOnlyResolvableTypes = new HashMap<String, ResolvableType>();
    private final Map<String, Method> kafakStreamsOnlyMethods = new HashMap<String, Method>();

    public KafkaStreamsFunctionBeanPostProcessor(StreamFunctionProperties streamFunctionProperties) {
        this.streamFunctionProperties = streamFunctionProperties;
    }

    public Map<String, ResolvableType> getResolvableTypes() {
        return this.resolvableTypeMap;
    }

    public Map<String, Method> getMethods() {
        return this.methods;
    }

    public void afterPropertiesSet() {
        String[] functionNames = this.beanFactory.getBeanNamesForType(Function.class);
        String[] biFunctionNames = this.beanFactory.getBeanNamesForType(BiFunction.class);
        String[] consumerNames = this.beanFactory.getBeanNamesForType(Consumer.class);
        String[] biConsumerNames = this.beanFactory.getBeanNamesForType(BiConsumer.class);
        Stream<String> concat = Stream.concat(Stream.concat(Stream.of(functionNames), Stream.of(consumerNames)), Stream.concat(Stream.of(biFunctionNames), Stream.of(biConsumerNames)));
        List collect = concat.collect(Collectors.toList());
        collect.removeIf(s -> Arrays.stream(EXCLUDE_FUNCTIONS).anyMatch(t -> t.equals(s)));
        collect.removeIf(Pattern.compile(".*_registration").asPredicate());
        this.onlySingleFunction = collect.size() == 1;
        collect.stream().forEach(this::extractResolvableTypes);
        this.kafkaStreamsOnlyResolvableTypes.keySet().forEach(k -> this.addResolvableTypeInfo((String)k, this.kafkaStreamsOnlyResolvableTypes.get(k)));
        this.kafakStreamsOnlyMethods.keySet().forEach(k -> this.addResolvableTypeInfo((String)k, this.kafakStreamsOnlyMethods.get(k)));
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.beanFactory;
        String definition = this.streamFunctionProperties.getDefinition();
        String[] functionUnits = KafkaStreamsBinderUtils.deriveFunctionUnits(definition);
        HashSet<String> kafkaStreamsMethodNames = new HashSet<String>(this.kafkaStreamsOnlyResolvableTypes.keySet());
        kafkaStreamsMethodNames.addAll(this.resolvableTypeMap.keySet());
        if (functionUnits.length == 0) {
            for (String s2 : this.getResolvableTypes().keySet()) {
                ResolvableType[] resolvableTypes = new ResolvableType[]{this.getResolvableTypes().get(s2)};
                RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(KafkaStreamsBindableProxyFactory.class);
                this.registerKakaStreamsProxyFactory(registry, s2, resolvableTypes, rootBeanDefinition);
            }
        } else {
            for (String functionUnit : functionUnits) {
                if (functionUnit.contains("|")) {
                    String[] composedFunctions = functionUnit.split("\\|");
                    String derivedNameFromComposed = "";
                    ResolvableType[] resolvableTypes = new ResolvableType[composedFunctions.length];
                    int i = 0;
                    boolean nonKafkaStreamsFunctionsFound = false;
                    for (String split : composedFunctions) {
                        derivedNameFromComposed = derivedNameFromComposed.concat(split);
                        resolvableTypes[i++] = this.getResolvableTypes().get(split);
                        if (kafkaStreamsMethodNames.contains(split)) continue;
                        nonKafkaStreamsFunctionsFound = true;
                        break;
                    }
                    if (nonKafkaStreamsFunctionsFound) continue;
                    RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(KafkaStreamsBindableProxyFactory.class);
                    this.registerKakaStreamsProxyFactory(registry, derivedNameFromComposed, resolvableTypes, rootBeanDefinition);
                    continue;
                }
                if (!kafkaStreamsMethodNames.contains(functionUnit)) continue;
                ResolvableType[] resolvableTypes = new ResolvableType[]{this.getResolvableTypes().get(functionUnit)};
                RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(KafkaStreamsBindableProxyFactory.class);
                this.registerKakaStreamsProxyFactory(registry, functionUnit, resolvableTypes, rootBeanDefinition);
            }
        }
    }

    private void registerKakaStreamsProxyFactory(BeanDefinitionRegistry registry, String s, ResolvableType[] resolvableTypes, RootBeanDefinition rootBeanDefinition) {
        rootBeanDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)resolvableTypes);
        rootBeanDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)s);
        rootBeanDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)this.getMethods().get(s));
        registry.registerBeanDefinition("kafkaStreamsBindableProxyFactory-" + s, (BeanDefinition)rootBeanDefinition);
    }

    private void extractResolvableTypes(String key) {
        Class classObj = ClassUtils.resolveClassName((String)((AnnotatedBeanDefinition)this.beanFactory.getBeanDefinition(key)).getMetadata().getClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
        try {
            Method[] methods = classObj.getDeclaredMethods();
            Optional<Method> functionalBeanMethods = KafkaStreamsBinderUtils.findMethodWithName(key, methods);
            if (functionalBeanMethods.isEmpty()) {
                methods = classObj.getMethods();
                functionalBeanMethods = KafkaStreamsBinderUtils.findMethodWithName(key, methods);
            }
            if (functionalBeanMethods.isEmpty()) {
                BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(key);
                String factoryMethodName = beanDefinition.getFactoryMethodName();
                functionalBeanMethods = KafkaStreamsBinderUtils.findMethodWithName(factoryMethodName, methods);
            }
            if (functionalBeanMethods.isPresent()) {
                Method method = functionalBeanMethods.get();
                ResolvableType resolvableType = ResolvableType.forMethodReturnType((Method)method, (Class)classObj);
                Class rawClass = resolvableType.getGeneric(new int[]{0}).getRawClass();
                if (rawClass == KStream.class || rawClass == KTable.class || rawClass == GlobalKTable.class) {
                    if (this.onlySingleFunction) {
                        this.resolvableTypeMap.put(key, resolvableType);
                    } else {
                        this.discoverOnlyKafkaStreamsResolvableTypes(key, resolvableType);
                    }
                }
            } else {
                Method method;
                ResolvableType resolvableType;
                Class rawClass;
                Optional<Method> componentBeanMethods = Arrays.stream(methods).filter(m -> m.getName().equals("apply") && this.isKafkaStreamsTypeFound((Method)m) || m.getName().equals("accept") && this.isKafkaStreamsTypeFound((Method)m)).findFirst();
                if (componentBeanMethods.isPresent() && ((rawClass = (resolvableType = ResolvableType.forMethodParameter((Method)(method = componentBeanMethods.get()), (int)0)).getRawClass()) == KStream.class || rawClass == KTable.class || rawClass == GlobalKTable.class)) {
                    if (this.onlySingleFunction) {
                        this.resolvableTypeMap.put(key, resolvableType);
                        this.methods.put(key, method);
                    } else {
                        this.discoverOnlyKafkaStreamsResolvableTypesAndMethods(key, resolvableType, method);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Function activation issues while mapping the function: " + key), (Throwable)e);
        }
    }

    private void addResolvableTypeInfo(String key, ResolvableType resolvableType) {
        if (this.kafkaStreamsOnlyResolvableTypes.size() == 1) {
            this.resolvableTypeMap.put(key, resolvableType);
        } else {
            String definition = this.streamFunctionProperties.getDefinition();
            if (definition == null) {
                throw new IllegalStateException("Multiple functions found, but function definition property is not set.");
            }
            if (definition.contains(key)) {
                this.resolvableTypeMap.put(key, resolvableType);
            }
        }
    }

    private void discoverOnlyKafkaStreamsResolvableTypes(String key, ResolvableType resolvableType) {
        this.kafkaStreamsOnlyResolvableTypes.put(key, resolvableType);
    }

    private void discoverOnlyKafkaStreamsResolvableTypesAndMethods(String key, ResolvableType resolvableType, Method method) {
        this.kafkaStreamsOnlyResolvableTypes.put(key, resolvableType);
        this.kafakStreamsOnlyMethods.put(key, method);
    }

    private void addResolvableTypeInfo(String key, Method method) {
        if (this.kafakStreamsOnlyMethods.size() == 1) {
            this.methods.put(key, method);
        } else {
            String definition = this.streamFunctionProperties.getDefinition();
            if (definition == null) {
                throw new IllegalStateException("Multiple functions found, but function definition property is not set.");
            }
            if (definition.contains(key)) {
                this.methods.put(key, method);
            }
        }
    }

    private boolean isKafkaStreamsTypeFound(Method method) {
        return KStream.class.isAssignableFrom(method.getParameters()[0].getType()) || KTable.class.isAssignableFrom(method.getParameters()[0].getType()) || GlobalKTable.class.isAssignableFrom(method.getParameters()[0].getType());
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }
}

