/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import io.micrometer.core.instrument.MeterRegistry;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.errors.LogAndContinueExceptionHandler;
import org.apache.kafka.streams.errors.LogAndFailExceptionHandler;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.kafka.KafkaConnectionDetails;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.cloud.stream.binder.BinderConfiguration;
import org.springframework.cloud.stream.binder.kafka.streams.DeserializationExceptionHandler;
import org.springframework.cloud.stream.binder.kafka.streams.DltPublishingContext;
import org.springframework.cloud.stream.binder.kafka.streams.EncodingDecodingBindAdviceHandler;
import org.springframework.cloud.stream.binder.kafka.streams.GlobalKTableBoundElementFactory;
import org.springframework.cloud.stream.binder.kafka.streams.InteractiveQueryService;
import org.springframework.cloud.stream.binder.kafka.streams.KStreamBoundElementFactory;
import org.springframework.cloud.stream.binder.kafka.streams.KTableBoundElementFactory;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBinderMetrics;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBindingInformationCatalogue;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsFunctionProcessor;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsMessageConversionDelegate;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsRegistry;
import org.springframework.cloud.stream.binder.kafka.streams.KeyValueSerdeResolver;
import org.springframework.cloud.stream.binder.kafka.streams.SendToDlqAndContinue;
import org.springframework.cloud.stream.binder.kafka.streams.StoreQueryParametersCustomizer;
import org.springframework.cloud.stream.binder.kafka.streams.StreamsBuilderFactoryManager;
import org.springframework.cloud.stream.binder.kafka.streams.function.FunctionDetectorCondition;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsExtendedBindingProperties;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.config.BinderProperties;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.kafka.config.KafkaStreamsConfiguration;
import org.springframework.kafka.config.StreamsBuilderFactoryBeanConfigurer;
import org.springframework.kafka.core.CleanupConfig;
import org.springframework.kafka.streams.KafkaStreamsMicrometerListener;
import org.springframework.kafka.streams.RecoveringDeserializationExceptionHandler;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={KafkaProperties.class, KafkaStreamsExtendedBindingProperties.class})
@ConditionalOnBean(value={BindingService.class})
@AutoConfigureAfter(value={BindingServiceConfiguration.class})
public class KafkaStreamsBinderSupportAutoConfiguration {
    private static final String KSTREAM_BINDER_TYPE = "kstream";
    private static final String KTABLE_BINDER_TYPE = "ktable";
    private static final String GLOBALKTABLE_BINDER_TYPE = "globalktable";
    private static final String CONSUMER_PROPERTIES_PREFIX = "consumer.";
    private static final String PRODUCER_PROPERTIES_PREFIX = "producer.";

    @Bean
    @ConfigurationProperties(prefix="spring.cloud.stream.kafka.streams.binder")
    public KafkaStreamsBinderConfigurationProperties binderConfigurationProperties(KafkaProperties kafkaProperties, ObjectProvider<KafkaConnectionDetails> kafkaConnectionDetails, ConfigurableEnvironment environment, BindingServiceProperties properties, ConfigurableApplicationContext context) throws Exception {
        Map<String, BinderConfiguration> binderConfigurations = KafkaStreamsBinderSupportAutoConfiguration.getBinderConfigurations(properties);
        for (Map.Entry<String, BinderConfiguration> entry : binderConfigurations.entrySet()) {
            BinderConfiguration binderConfiguration = entry.getValue();
            String binderType = binderConfiguration.getBinderType();
            if (binderType == null || !binderType.equals(KSTREAM_BINDER_TYPE) && !binderType.equals(KTABLE_BINDER_TYPE) && !binderType.equals(GLOBALKTABLE_BINDER_TYPE)) continue;
            HashMap<String, Object> binderProperties = new HashMap<String, Object>();
            this.flatten(null, binderConfiguration.getProperties(), binderProperties);
            environment.getPropertySources().addFirst((PropertySource)new MapPropertySource(entry.getKey() + "-kafkaStreamsBinderEnv", binderProperties));
            Binder binder = new Binder(ConfigurationPropertySources.get((Environment)environment), (PlaceholdersResolver)new PropertySourcesPlaceholdersResolver((Environment)environment), IntegrationUtils.getConversionService((BeanFactory)context.getBeanFactory()), null);
            Constructor kafkaStreamsBinderConfigurationPropertiesConstructor = ReflectionUtils.accessibleConstructor(KafkaStreamsBinderConfigurationProperties.class, (Class[])new Class[]{KafkaProperties.class, ObjectProvider.class});
            KafkaStreamsBinderConfigurationProperties kafkaStreamsBinderConfigurationProperties = (KafkaStreamsBinderConfigurationProperties)((Object)BeanUtils.instantiateClass((Constructor)kafkaStreamsBinderConfigurationPropertiesConstructor, (Object[])new Object[]{kafkaProperties, new EmptyObjectProvider()}));
            BindResult bind = binder.bind("spring.cloud.stream.kafka.streams.binder", Bindable.ofInstance((Object)((Object)kafkaStreamsBinderConfigurationProperties)));
            context.getBeanFactory().registerSingleton(entry.getKey() + "-KafkaStreamsBinderConfigurationProperties", bind.get());
        }
        return new KafkaStreamsBinderConfigurationProperties(kafkaProperties, kafkaConnectionDetails);
    }

    private static Map<String, BinderConfiguration> getBinderConfigurations(BindingServiceProperties properties) {
        HashMap<String, BinderConfiguration> binderConfigurations = new HashMap<String, BinderConfiguration>();
        Map declaredBinders = properties.getBinders();
        for (Map.Entry binderEntry : declaredBinders.entrySet()) {
            BinderProperties binderProperties = (BinderProperties)binderEntry.getValue();
            binderConfigurations.put((String)binderEntry.getKey(), new BinderConfiguration(binderProperties.getType(), binderProperties.getEnvironment(), binderProperties.isInheritEnvironment(), binderProperties.isDefaultCandidate()));
        }
        return binderConfigurations;
    }

    private void flatten(String propertyName, Object value, Map<String, Object> flattenedProperties) {
        if (value instanceof Map) {
            Map valueAsMap = (Map)value;
            valueAsMap.forEach((k, v) -> this.flatten((String)(propertyName != null ? propertyName + "." : "") + k, v, flattenedProperties));
        } else {
            flattenedProperties.put(propertyName, value.toString());
        }
    }

    @Bean
    public KafkaStreamsConfiguration kafkaStreamsConfiguration(@Qualifier(value="binderConfigurationProperties") KafkaStreamsBinderConfigurationProperties properties, Environment environment) {
        String applicationName;
        KafkaProperties kafkaProperties = properties.getKafkaProperties();
        Map streamsProperties = kafkaProperties.buildStreamsProperties();
        if (kafkaProperties.getStreams().getApplicationId() == null && (applicationName = environment.getProperty("spring.application.name")) != null) {
            streamsProperties.put("application.id", applicationName);
        }
        return new KafkaStreamsConfiguration(streamsProperties);
    }

    @Bean(value={"streamConfigGlobalProperties"})
    public Map<String, Object> streamConfigGlobalProperties(@Qualifier(value="binderConfigurationProperties") KafkaStreamsBinderConfigurationProperties configProperties, KafkaStreamsConfiguration kafkaStreamsConfiguration, ConfigurableEnvironment environment, SendToDlqAndContinue sendToDlqAndContinue) {
        String kafkaBinderBroker;
        String kafkaStreamsBinderBroker;
        Properties properties = kafkaStreamsConfiguration.asProperties();
        String kafkaConnectionString = configProperties.getKafkaConnectionString();
        if (kafkaConnectionString != null && kafkaConnectionString.equals("localhost:9092") && !StringUtils.hasText((String)(kafkaStreamsBinderBroker = environment.getProperty("spring.cloud.stream.kafka.streams.binder.brokers"))) && StringUtils.hasText((String)(kafkaBinderBroker = environment.getProperty("spring.cloud.stream.kafka.binder.brokers")))) {
            kafkaConnectionString = kafkaBinderBroker;
            configProperties.setBrokers(new String[]{kafkaConnectionString});
        }
        if (ObjectUtils.isEmpty((Object)properties.get("bootstrap.servers"))) {
            properties.put("bootstrap.servers", kafkaConnectionString);
        } else {
            List bootStrapCollection;
            Object bootstrapServerConfig = properties.get("bootstrap.servers");
            if (bootstrapServerConfig instanceof String) {
                String bootStrapServers = (String)bootstrapServerConfig;
                if (bootStrapServers.equals("localhost:9092")) {
                    properties.put("bootstrap.servers", kafkaConnectionString);
                }
            } else if (bootstrapServerConfig instanceof List && (bootStrapCollection = (List)bootstrapServerConfig).size() == 1 && bootStrapCollection.get(0).equals("localhost:9092")) {
                properties.put("bootstrap.servers", kafkaConnectionString);
            }
        }
        String binderProvidedApplicationId = configProperties.getApplicationId();
        if (StringUtils.hasText((String)binderProvidedApplicationId)) {
            properties.put("application.id", binderProvidedApplicationId);
        }
        properties.put("default.key.serde", Serdes.ByteArraySerde.class.getName());
        properties.put("default.value.serde", Serdes.ByteArraySerde.class.getName());
        if (configProperties.getDeserializationExceptionHandler() == DeserializationExceptionHandler.logAndContinue) {
            properties.put("default.deserialization.exception.handler", LogAndContinueExceptionHandler.class);
        } else if (configProperties.getDeserializationExceptionHandler() == DeserializationExceptionHandler.logAndFail) {
            properties.put("default.deserialization.exception.handler", LogAndFailExceptionHandler.class);
        } else if (configProperties.getDeserializationExceptionHandler() == DeserializationExceptionHandler.sendToDlq) {
            properties.put("default.deserialization.exception.handler", RecoveringDeserializationExceptionHandler.class);
            properties.put("spring.deserialization.recoverer", sendToDlqAndContinue);
        }
        if (!ObjectUtils.isEmpty((Object)configProperties.getConfiguration())) {
            properties.putAll((Map<?, ?>)configProperties.getConfiguration());
        }
        HashMap<String, Object> mergedConsumerConfig = new HashMap<String, Object>(configProperties.mergedConsumerConfiguration());
        this.addPrefix(properties, mergedConsumerConfig, CONSUMER_PROPERTIES_PREFIX);
        HashMap<String, Object> mergedProducerConfig = new HashMap<String, Object>(configProperties.mergedProducerConfiguration());
        this.addPrefix(properties, mergedProducerConfig, PRODUCER_PROPERTIES_PREFIX);
        if (!properties.containsKey("replication.factor")) {
            properties.put("replication.factor", (Object)configProperties.getReplicationFactor());
        }
        return properties.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), Map.Entry::getValue));
    }

    private void addPrefix(Properties properties, Map<String, Object> mergedConsProdConfig, String prefix) {
        HashMap<Object, Object> mergedConfigs = new HashMap<Object, Object>();
        for (String key : mergedConsProdConfig.keySet()) {
            mergedConfigs.put(key.startsWith(prefix) ? key : prefix + key, mergedConsProdConfig.get(key));
        }
        if (!ObjectUtils.isEmpty(mergedConfigs)) {
            properties.putAll((Map<?, ?>)mergedConfigs);
        }
    }

    @Bean
    public KafkaStreamsMessageConversionDelegate messageConversionDelegate(@Qualifier(value="integrationArgumentResolverMessageConverter") CompositeMessageConverter compositeMessageConverter, SendToDlqAndContinue sendToDlqAndContinue, KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue2, @Qualifier(value="binderConfigurationProperties") KafkaStreamsBinderConfigurationProperties binderConfigurationProperties) {
        return new KafkaStreamsMessageConversionDelegate(compositeMessageConverter, sendToDlqAndContinue, KafkaStreamsBindingInformationCatalogue2, binderConfigurationProperties);
    }

    @Bean
    public KStreamBoundElementFactory kStreamBoundElementFactory(BindingServiceProperties bindingServiceProperties, KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue2, EncodingDecodingBindAdviceHandler encodingDecodingBindAdviceHandler) {
        return new KStreamBoundElementFactory(bindingServiceProperties, KafkaStreamsBindingInformationCatalogue2, encodingDecodingBindAdviceHandler);
    }

    @Bean
    public KTableBoundElementFactory kTableBoundElementFactory(BindingServiceProperties bindingServiceProperties, EncodingDecodingBindAdviceHandler encodingDecodingBindAdviceHandler, KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue2) {
        return new KTableBoundElementFactory(bindingServiceProperties, encodingDecodingBindAdviceHandler, KafkaStreamsBindingInformationCatalogue2);
    }

    @Bean
    public GlobalKTableBoundElementFactory globalKTableBoundElementFactory(BindingServiceProperties properties, EncodingDecodingBindAdviceHandler encodingDecodingBindAdviceHandler, KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue2) {
        return new GlobalKTableBoundElementFactory(properties, encodingDecodingBindAdviceHandler, KafkaStreamsBindingInformationCatalogue2);
    }

    @Bean
    public SendToDlqAndContinue sendToDlqAndContinue() {
        return new SendToDlqAndContinue();
    }

    @Bean
    public KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue() {
        return new KafkaStreamsBindingInformationCatalogue();
    }

    @Bean
    @ConditionalOnMissingBean
    public KeyValueSerdeResolver keyValueSerdeResolver(@Qualifier(value="streamConfigGlobalProperties") Object streamConfigGlobalProperties, @Qualifier(value="binderConfigurationProperties") KafkaStreamsBinderConfigurationProperties properties) {
        return new KeyValueSerdeResolver((Map)streamConfigGlobalProperties, properties);
    }

    @Bean
    public InteractiveQueryService interactiveQueryServices(KafkaStreamsRegistry kafkaStreamsRegistry, @Qualifier(value="binderConfigurationProperties") KafkaStreamsBinderConfigurationProperties properties, ObjectProvider<StoreQueryParametersCustomizer<?>> storeQueryParametersCustomizerProvider) {
        InteractiveQueryService interactiveQueryService = new InteractiveQueryService(kafkaStreamsRegistry, properties);
        StoreQueryParametersCustomizer storeQueryParametersCustomizer = (StoreQueryParametersCustomizer)storeQueryParametersCustomizerProvider.getIfUnique();
        if (storeQueryParametersCustomizer != null) {
            interactiveQueryService.setStoreQueryParametersCustomizer(storeQueryParametersCustomizer);
        }
        return interactiveQueryService;
    }

    @Bean
    public KafkaStreamsRegistry kafkaStreamsRegistry() {
        return new KafkaStreamsRegistry();
    }

    @Bean
    public StreamsBuilderFactoryManager streamsBuilderFactoryManager(KafkaStreamsBindingInformationCatalogue catalogue, KafkaStreamsRegistry kafkaStreamsRegistry, @Nullable KafkaStreamsBinderMetrics kafkaStreamsBinderMetrics, @Nullable KafkaStreamsMicrometerListener listener, KafkaProperties kafkaProperties) {
        return new StreamsBuilderFactoryManager(catalogue, kafkaStreamsRegistry, kafkaStreamsBinderMetrics, listener, kafkaProperties);
    }

    @Bean
    @Conditional(value={FunctionDetectorCondition.class})
    public KafkaStreamsFunctionProcessor kafkaStreamsFunctionProcessor(BindingServiceProperties bindingServiceProperties, KafkaStreamsExtendedBindingProperties kafkaStreamsExtendedBindingProperties, KeyValueSerdeResolver keyValueSerdeResolver, KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue, KafkaStreamsMessageConversionDelegate kafkaStreamsMessageConversionDelegate, ObjectProvider<CleanupConfig> cleanupConfig, StreamFunctionProperties streamFunctionProperties, @Qualifier(value="binderConfigurationProperties") KafkaStreamsBinderConfigurationProperties kafkaStreamsBinderConfigurationProperties, ObjectProvider<StreamsBuilderFactoryBeanConfigurer> customizerProvider, ConfigurableEnvironment environment) {
        return new KafkaStreamsFunctionProcessor(bindingServiceProperties, kafkaStreamsExtendedBindingProperties, keyValueSerdeResolver, kafkaStreamsBindingInformationCatalogue, kafkaStreamsMessageConversionDelegate, (CleanupConfig)cleanupConfig.getIfUnique(), streamFunctionProperties, kafkaStreamsBinderConfigurationProperties, (StreamsBuilderFactoryBeanConfigurer)customizerProvider.getIfUnique(), environment);
    }

    @Bean
    public EncodingDecodingBindAdviceHandler encodingDecodingBindAdviceHandler() {
        return new EncodingDecodingBindAdviceHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public DltPublishingContext dltSenderContext() {
        return new DltPublishingContext();
    }

    private static class EmptyObjectProvider<T>
    implements ObjectProvider<T> {
        private EmptyObjectProvider() {
        }

        public T getObject() throws BeansException {
            return null;
        }

        public T getObject(Object ... args) throws BeansException {
            return null;
        }

        public T getIfAvailable() throws BeansException {
            return null;
        }

        public T getIfUnique() throws BeansException {
            return null;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(name={"outerContext"})
    @ConditionalOnMissingBean(value={KafkaStreamsBinderMetrics.class})
    @ConditionalOnClass(name={"io.micrometer.core.instrument.MeterRegistry"})
    protected class KafkaStreamsBinderMetricsConfigurationWithMultiBinder {
        protected KafkaStreamsBinderMetricsConfigurationWithMultiBinder() {
        }

        @Bean
        @ConditionalOnMissingClass(value={"org.springframework.kafka.core.MicrometerConsumerListener"})
        public KafkaStreamsBinderMetrics kafkaStreamsBinderMetrics(ConfigurableApplicationContext context) {
            MeterRegistry meterRegistry = (MeterRegistry)((ApplicationContext)context.getBean("outerContext", ApplicationContext.class)).getBean(MeterRegistry.class);
            return new KafkaStreamsBinderMetrics(meterRegistry);
        }

        @ConditionalOnClass(name={"org.springframework.kafka.core.MicrometerConsumerListener"})
        @ConditionalOnBean(value={MeterRegistry.class})
        protected class KafkaMicrometer {
            protected KafkaMicrometer() {
            }

            @Bean
            @ConditionalOnMissingBean(name={"binderStreamsListener"})
            public KafkaStreamsMicrometerListener binderStreamsListener(MeterRegistry meterRegistry) {
                return new KafkaStreamsMicrometerListener(meterRegistry);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={KafkaStreamsBinderMetrics.class}, name={"outerContext"})
    @ConditionalOnClass(name={"io.micrometer.core.instrument.MeterRegistry"})
    protected class KafkaStreamsBinderMetricsConfiguration {
        protected KafkaStreamsBinderMetricsConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={MeterRegistry.class})
        @ConditionalOnMissingBean(value={KafkaStreamsBinderMetrics.class})
        @ConditionalOnMissingClass(value={"org.springframework.kafka.core.MicrometerConsumerListener"})
        public KafkaStreamsBinderMetrics kafkaStreamsBinderMetrics(MeterRegistry meterRegistry) {
            return new KafkaStreamsBinderMetrics(meterRegistry);
        }

        @ConditionalOnClass(name={"org.springframework.kafka.core.MicrometerConsumerListener"})
        @ConditionalOnBean(value={MeterRegistry.class})
        protected class KafkaMicrometer {
            protected KafkaMicrometer() {
            }

            @Bean
            @ConditionalOnMissingBean(name={"binderStreamsListener"})
            public KafkaStreamsMicrometerListener binderStreamsListener(MeterRegistry meterRegistry) {
                return new KafkaStreamsMicrometerListener(meterRegistry);
            }
        }
    }
}

