/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit.config;

import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.support.postprocessor.DelegatingDecompressingPostProcessor;
import org.springframework.amqp.support.postprocessor.GZipPostProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.rabbit.RabbitMessageChannelBinder;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitExtendedBindingProperties;
import org.springframework.cloud.stream.binder.rabbit.provisioning.RabbitExchangeQueueProvisioner;
import org.springframework.cloud.stream.config.ListenerContainerCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.lang.Nullable;

@Configuration
@Import(value={PropertyPlaceholderAutoConfiguration.class})
@EnableConfigurationProperties(value={RabbitBinderConfigurationProperties.class, RabbitExtendedBindingProperties.class})
public class RabbitMessageChannelBinderConfiguration {
    @Autowired
    private ConnectionFactory rabbitConnectionFactory;
    @Autowired
    private RabbitProperties rabbitProperties;
    @Autowired
    private RabbitBinderConfigurationProperties rabbitBinderConfigurationProperties;
    @Autowired
    private RabbitExtendedBindingProperties rabbitExtendedBindingProperties;

    @Bean
    RabbitMessageChannelBinder rabbitMessageChannelBinder(@Nullable ListenerContainerCustomizer<AbstractMessageListenerContainer> listenerContainerCustomizer) throws Exception {
        RabbitMessageChannelBinder binder = new RabbitMessageChannelBinder(this.rabbitConnectionFactory, this.rabbitProperties, this.provisioningProvider(), listenerContainerCustomizer);
        binder.setAdminAddresses(this.rabbitBinderConfigurationProperties.getAdminAddresses());
        binder.setCompressingPostProcessor(this.gZipPostProcessor());
        binder.setDecompressingPostProcessor(this.deCompressingPostProcessor());
        binder.setNodes(this.rabbitBinderConfigurationProperties.getNodes());
        binder.setExtendedBindingProperties(this.rabbitExtendedBindingProperties);
        return binder;
    }

    @Bean
    MessagePostProcessor deCompressingPostProcessor() {
        return new DelegatingDecompressingPostProcessor();
    }

    @Bean
    MessagePostProcessor gZipPostProcessor() {
        GZipPostProcessor gZipPostProcessor = new GZipPostProcessor();
        gZipPostProcessor.setLevel(this.rabbitBinderConfigurationProperties.getCompressionLevel());
        return gZipPostProcessor;
    }

    @Bean
    RabbitExchangeQueueProvisioner provisioningProvider() {
        return new RabbitExchangeQueueProvisioner(this.rabbitConnectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={ConnectionNameStrategy.class})
    @ConditionalOnProperty(value={"spring.cloud.stream.rabbit.binder.connection-name-prefix"})
    public ConnectionNameStrategy connectionNamer(CachingConnectionFactory cf) {
        AtomicInteger nameIncrementer = new AtomicInteger();
        ConnectionNameStrategy namer = f -> this.rabbitBinderConfigurationProperties.getConnectionNamePrefix() + "#" + nameIncrementer.getAndIncrement();
        cf.setConnectionNameStrategy(namer);
        return namer;
    }
}

