/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rocketmq;

import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.LocalTransactionExecuter;
import org.apache.rocketmq.client.producer.TransactionCheckListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.binder.rocketmq.consuming.ConsumersManager;
import org.springframework.cloud.stream.binder.rocketmq.integration.RocketMQInboundChannelAdapter;
import org.springframework.cloud.stream.binder.rocketmq.integration.RocketMQMessageHandler;
import org.springframework.cloud.stream.binder.rocketmq.metrics.InstrumentationManager;
import org.springframework.cloud.stream.binder.rocketmq.properties.RocketMQBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.rocketmq.properties.RocketMQConsumerProperties;
import org.springframework.cloud.stream.binder.rocketmq.properties.RocketMQExtendedBindingProperties;
import org.springframework.cloud.stream.binder.rocketmq.properties.RocketMQProducerProperties;
import org.springframework.cloud.stream.binder.rocketmq.provisioning.RocketMQTopicProvisioner;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.integration.core.MessageProducer;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.retry.RecoveryCallback;
import org.springframework.util.ClassUtils;

public class RocketMQMessageChannelBinder
extends AbstractMessageChannelBinder<ExtendedConsumerProperties<RocketMQConsumerProperties>, ExtendedProducerProperties<RocketMQProducerProperties>, RocketMQTopicProvisioner>
implements ExtendedPropertiesBinder<MessageChannel, RocketMQConsumerProperties, RocketMQProducerProperties> {
    private static final Logger logger = LoggerFactory.getLogger(RocketMQMessageChannelBinder.class);
    private final RocketMQExtendedBindingProperties extendedBindingProperties;
    private final RocketMQBinderConfigurationProperties rocketBinderConfigurationProperties;
    private final InstrumentationManager instrumentationManager;
    private final ConsumersManager consumersManager;

    public RocketMQMessageChannelBinder(ConsumersManager consumersManager, RocketMQExtendedBindingProperties extendedBindingProperties, RocketMQTopicProvisioner provisioningProvider, RocketMQBinderConfigurationProperties rocketBinderConfigurationProperties, InstrumentationManager instrumentationManager) {
        super(null, (ProvisioningProvider)provisioningProvider);
        this.consumersManager = consumersManager;
        this.extendedBindingProperties = extendedBindingProperties;
        this.rocketBinderConfigurationProperties = rocketBinderConfigurationProperties;
        this.instrumentationManager = instrumentationManager;
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, ExtendedProducerProperties<RocketMQProducerProperties> producerProperties, MessageChannel errorChannel) throws Exception {
        if (((RocketMQProducerProperties)producerProperties.getExtension()).getEnabled().booleanValue()) {
            RocketMQMessageHandler messageHandler = new RocketMQMessageHandler(destination.getName(), producerProperties, this.rocketBinderConfigurationProperties, this.instrumentationManager);
            if (((RocketMQProducerProperties)producerProperties.getExtension()).getTransactional().booleanValue()) {
                messageHandler.setLocalTransactionExecuter(this.getClassConfiguration(destination.getName(), ((RocketMQProducerProperties)producerProperties.getExtension()).getExecuter(), LocalTransactionExecuter.class));
                messageHandler.setTransactionCheckListener(this.getClassConfiguration(destination.getName(), ((RocketMQProducerProperties)producerProperties.getExtension()).getTransactionCheckListener(), TransactionCheckListener.class));
            }
            return messageHandler;
        }
        throw new RuntimeException("Binding for channel " + destination.getName() + " has been disabled, message can't be delivered");
    }

    protected MessageProducer createConsumerEndpoint(ConsumerDestination destination, String group, ExtendedConsumerProperties<RocketMQConsumerProperties> consumerProperties) throws Exception {
        if (group == null || "".equals(group)) {
            throw new RuntimeException("'group must be configured for channel + " + destination.getName());
        }
        RocketMQInboundChannelAdapter rocketInboundChannelAdapter = new RocketMQInboundChannelAdapter(this.consumersManager, consumerProperties, destination.getName(), group, this.instrumentationManager);
        AbstractMessageChannelBinder.ErrorInfrastructure errorInfrastructure = this.registerErrorInfrastructure(destination, group, (ConsumerProperties)consumerProperties);
        if (consumerProperties.getMaxAttempts() > 1) {
            rocketInboundChannelAdapter.setRetryTemplate(this.buildRetryTemplate((ConsumerProperties)consumerProperties));
            rocketInboundChannelAdapter.setRecoveryCallback((RecoveryCallback<? extends Object>)errorInfrastructure.getRecoverer());
        } else {
            rocketInboundChannelAdapter.setErrorChannel((MessageChannel)errorInfrastructure.getErrorChannel());
        }
        return rocketInboundChannelAdapter;
    }

    public RocketMQConsumerProperties getExtendedConsumerProperties(String channelName) {
        return this.extendedBindingProperties.getExtendedConsumerProperties(channelName);
    }

    public RocketMQProducerProperties getExtendedProducerProperties(String channelName) {
        return this.extendedBindingProperties.getExtendedProducerProperties(channelName);
    }

    private <T> T getClassConfiguration(String destName, String className, Class<T> interfaceClass) {
        if (StringUtils.isEmpty((CharSequence)className)) {
            throw new RuntimeException("Binding for channel " + destName + " using transactional message, should set " + interfaceClass.getSimpleName() + " configuration" + interfaceClass.getSimpleName() + " should be set, like 'spring.cloud.stream.rocketmq.bindings.output.producer.xxx=TheFullClassNameOfYour" + interfaceClass.getSimpleName() + "'");
        }
        if (StringUtils.isNotEmpty((CharSequence)className)) {
            Class fieldClass;
            try {
                fieldClass = ClassUtils.forName((String)className, (ClassLoader)RocketMQMessageChannelBinder.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Binding for channel " + destName + " using transactional message, but " + className + " class is not found");
            }
            if (!interfaceClass.isAssignableFrom(fieldClass)) {
                throw new RuntimeException("Binding for channel " + destName + " using transactional message, but " + className + " is incompatible with " + interfaceClass.getSimpleName() + " interface");
            }
            try {
                return fieldClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Binding for channel " + destName + " using transactional message, but " + className + " instance error", e);
            }
        }
        return null;
    }
}

