/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rocketmq;

import java.util.HashMap;
import java.util.Map;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.MessageConst;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.cloud.stream.binder.rocketmq.consuming.Acknowledgement;
import org.springframework.integration.support.MutableMessage;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageHeaderAccessor;

public class RocketMQMessageHeaderAccessor
extends MessageHeaderAccessor {
    public RocketMQMessageHeaderAccessor() {
    }

    public RocketMQMessageHeaderAccessor(Message<?> message) {
        super(message);
    }

    public Acknowledgement getAcknowledgement(Message message) {
        return (Acknowledgement)message.getHeaders().get((Object)"ACKNOWLEDGEMENT", Acknowledgement.class);
    }

    public RocketMQMessageHeaderAccessor withAcknowledgment(Acknowledgement acknowledgment) {
        this.setHeader("ACKNOWLEDGEMENT", acknowledgment);
        return this;
    }

    public String getTags() {
        return (String)this.getMessageHeaders().getOrDefault((Object)"TAGS", (Object)"");
    }

    public RocketMQMessageHeaderAccessor withTags(String tag) {
        this.setHeader("TAGS", tag);
        return this;
    }

    public String getKeys() {
        return (String)this.getMessageHeaders().getOrDefault((Object)"KEYS", (Object)"");
    }

    public RocketMQMessageHeaderAccessor withKeys(String keys) {
        this.setHeader("KEYS", keys);
        return this;
    }

    public MessageExt getRocketMessage() {
        return (MessageExt)this.getMessageHeaders().get((Object)"ORIGINAL_ROCKETMQ_MESSAGE", MessageExt.class);
    }

    public RocketMQMessageHeaderAccessor withRocketMessage(MessageExt message) {
        this.setHeader("ORIGINAL_ROCKETMQ_MESSAGE", message);
        return this;
    }

    public Integer getDelayTimeLevel() {
        return (Integer)this.getMessageHeaders().getOrDefault((Object)"DELAY", (Object)0);
    }

    public RocketMQMessageHeaderAccessor withDelayTimeLevel(Integer delayTimeLevel) {
        this.setHeader("DELAY", delayTimeLevel);
        return this;
    }

    public Integer getFlag() {
        return (Integer)this.getMessageHeaders().getOrDefault((Object)"ROCKETMQ_FLAG", (Object)0);
    }

    public RocketMQMessageHeaderAccessor withFlag(Integer delayTimeLevel) {
        this.setHeader("ROCKETMQ_FLAG", delayTimeLevel);
        return this;
    }

    public Object getTransactionalArg() {
        return this.getMessageHeaders().get((Object)"ROCKETMQ_TRANSACTIONAL_ARG");
    }

    public Object withTransactionalArg(Object arg) {
        this.setHeader("ROCKETMQ_TRANSACTIONAL_ARG", arg);
        return this;
    }

    public SendResult getSendResult() {
        return (SendResult)this.getMessageHeaders().get((Object)"ROCKETMQ_SEND_RESULT", SendResult.class);
    }

    public static void putSendResult(MutableMessage message, SendResult sendResult) {
        message.getHeaders().put("ROCKETMQ_SEND_RESULT", (Object)sendResult);
    }

    public Map<String, String> getUserProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : this.toMap().entrySet()) {
            if (!(entry.getValue() instanceof String) || MessageConst.STRING_HASH_SET.contains(entry.getKey()) || ((String)entry.getKey()).equals("contentType")) continue;
            result.put((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }
}

