/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rocketmq.actuator;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.cloud.stream.binder.rocketmq.metrics.InstrumentationManager;

@Endpoint(id="rocketmq-binder")
public class RocketMQBinderEndpoint {
    @Autowired(required=false)
    private InstrumentationManager instrumentationManager;

    @ReadOperation
    public Map<String, Object> invoke() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.instrumentationManager != null) {
            result.put("metrics", this.instrumentationManager.getMetricRegistry().getMetrics());
            result.put("runtime", this.instrumentationManager.getRuntime());
        } else {
            result.put("warning", "please add metrics-core dependency, we use it for metrics");
        }
        return result;
    }
}

