/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rocketmq.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.rocketmq.RocketMQMessageChannelBinder;
import org.springframework.cloud.stream.binder.rocketmq.consuming.ConsumersManager;
import org.springframework.cloud.stream.binder.rocketmq.metrics.InstrumentationManager;
import org.springframework.cloud.stream.binder.rocketmq.properties.RocketMQBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.rocketmq.properties.RocketMQExtendedBindingProperties;
import org.springframework.cloud.stream.binder.rocketmq.provisioning.RocketMQTopicProvisioner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={RocketMQBinderConfigurationProperties.class, RocketMQExtendedBindingProperties.class})
public class RocketMQBinderAutoConfiguration {
    private final RocketMQExtendedBindingProperties extendedBindingProperties;
    private final RocketMQBinderConfigurationProperties rocketBinderConfigurationProperties;
    @Autowired(required=false)
    private InstrumentationManager instrumentationManager;

    @Autowired
    public RocketMQBinderAutoConfiguration(RocketMQExtendedBindingProperties extendedBindingProperties, RocketMQBinderConfigurationProperties rocketBinderConfigurationProperties) {
        this.extendedBindingProperties = extendedBindingProperties;
        this.rocketBinderConfigurationProperties = rocketBinderConfigurationProperties;
        System.setProperty("rocketmq.client.logLevel", this.rocketBinderConfigurationProperties.getLogLevel());
    }

    @Bean
    public RocketMQTopicProvisioner provisioningProvider() {
        return new RocketMQTopicProvisioner();
    }

    @Bean
    public RocketMQMessageChannelBinder rocketMessageChannelBinder(RocketMQTopicProvisioner provisioningProvider, ConsumersManager consumersManager) {
        RocketMQMessageChannelBinder binder = new RocketMQMessageChannelBinder(consumersManager, this.extendedBindingProperties, provisioningProvider, this.rocketBinderConfigurationProperties, this.instrumentationManager);
        return binder;
    }

    @Bean
    public ConsumersManager consumersManager() {
        return new ConsumersManager(this.instrumentationManager, this.rocketBinderConfigurationProperties);
    }
}

