/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rocketmq.consuming;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.rocketmq.metrics.ConsumerGroupInstrumentation;
import org.springframework.cloud.stream.binder.rocketmq.metrics.InstrumentationManager;
import org.springframework.cloud.stream.binder.rocketmq.properties.RocketMQBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.rocketmq.properties.RocketMQConsumerProperties;

public class ConsumersManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, DefaultMQPushConsumer> consumerGroups = new HashMap<String, DefaultMQPushConsumer>();
    private final Map<String, Boolean> started = new HashMap<String, Boolean>();
    private final Map<Map.Entry<String, String>, ExtendedConsumerProperties<RocketMQConsumerProperties>> propertiesMap = new HashMap<Map.Entry<String, String>, ExtendedConsumerProperties<RocketMQConsumerProperties>>();
    private final RocketMQBinderConfigurationProperties rocketBinderConfigurationProperties;
    private InstrumentationManager instrumentationManager;

    public ConsumersManager(InstrumentationManager instrumentationManager, RocketMQBinderConfigurationProperties rocketBinderConfigurationProperties) {
        this.instrumentationManager = instrumentationManager;
        this.rocketBinderConfigurationProperties = rocketBinderConfigurationProperties;
    }

    public synchronized DefaultMQPushConsumer getOrCreateConsumer(String group, String topic, ExtendedConsumerProperties<RocketMQConsumerProperties> consumerProperties) {
        this.propertiesMap.put(new AbstractMap.SimpleEntry<String, String>(group, topic), consumerProperties);
        Optional.ofNullable(this.instrumentationManager).ifPresent(manager -> {
            ConsumerGroupInstrumentation instrumentation = manager.getConsumerGroupInstrumentation(group);
            this.instrumentationManager.addHealthInstrumentation(instrumentation);
        });
        if (this.consumerGroups.containsKey(group)) {
            return this.consumerGroups.get(group);
        }
        DefaultMQPushConsumer consumer = new DefaultMQPushConsumer(group);
        consumer.setNamesrvAddr(this.rocketBinderConfigurationProperties.getNamesrvAddr());
        this.consumerGroups.put(group, consumer);
        this.started.put(group, false);
        consumer.setConsumeThreadMax(consumerProperties.getConcurrency());
        consumer.setConsumeThreadMin(consumerProperties.getConcurrency());
        if (((RocketMQConsumerProperties)consumerProperties.getExtension()).getBroadcasting().booleanValue()) {
            consumer.setMessageModel(MessageModel.BROADCASTING);
        }
        this.logger.info("RocketMQ consuming for SCS group {} created", (Object)group);
        return consumer;
    }

    public synchronized void startConsumers() throws MQClientException {
        for (String group : this.getConsumerGroups()) {
            this.start(group);
        }
    }

    public synchronized void startConsumer(String group) throws MQClientException {
        this.start(group);
    }

    public synchronized void stopConsumer(String group) {
        this.stop(group);
    }

    private void stop(String group) {
        if (this.consumerGroups.get(group) != null) {
            this.consumerGroups.get(group).shutdown();
            this.started.put(group, false);
        }
    }

    private synchronized void start(String group) throws MQClientException {
        if (this.started.get(group).booleanValue()) {
            return;
        }
        ConsumerGroupInstrumentation groupInstrumentation = null;
        if (Optional.ofNullable(this.instrumentationManager).isPresent()) {
            groupInstrumentation = this.instrumentationManager.getConsumerGroupInstrumentation(group);
            this.instrumentationManager.addHealthInstrumentation(groupInstrumentation);
        }
        try {
            this.consumerGroups.get(group).start();
            this.started.put(group, true);
            Optional.ofNullable(groupInstrumentation).ifPresent(g -> g.markStartedSuccessfully());
        }
        catch (MQClientException e) {
            Optional.ofNullable(groupInstrumentation).ifPresent(g -> g.markStartFailed((Exception)((Object)e)));
            this.logger.error("RocketMQ Consumer hasn't been started. Caused by " + e.getErrorMessage(), (Throwable)e);
            throw e;
        }
    }

    public synchronized Set<String> getConsumerGroups() {
        return this.consumerGroups.keySet();
    }
}

