/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rocketmq.integration;

import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.LocalTransactionExecuter;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.client.producer.TransactionCheckListener;
import org.apache.rocketmq.client.producer.TransactionMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.rocketmq.RocketMQMessageHeaderAccessor;
import org.springframework.cloud.stream.binder.rocketmq.metrics.InstrumentationManager;
import org.springframework.cloud.stream.binder.rocketmq.metrics.ProducerInstrumentation;
import org.springframework.cloud.stream.binder.rocketmq.properties.RocketMQBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.rocketmq.properties.RocketMQProducerProperties;
import org.springframework.context.Lifecycle;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.support.MutableMessage;
import org.springframework.messaging.MessagingException;

public class RocketMQMessageHandler
extends AbstractMessageHandler
implements Lifecycle {
    private DefaultMQProducer producer;
    private ProducerInstrumentation producerInstrumentation;
    private InstrumentationManager instrumentationManager;
    private LocalTransactionExecuter localTransactionExecuter;
    private TransactionCheckListener transactionCheckListener;
    private final ExtendedProducerProperties<RocketMQProducerProperties> producerProperties;
    private final String destination;
    private final RocketMQBinderConfigurationProperties rocketBinderConfigurationProperties;
    private volatile boolean running = false;

    public RocketMQMessageHandler(String destination, ExtendedProducerProperties<RocketMQProducerProperties> producerProperties, RocketMQBinderConfigurationProperties rocketBinderConfigurationProperties, InstrumentationManager instrumentationManager) {
        this.destination = destination;
        this.producerProperties = producerProperties;
        this.rocketBinderConfigurationProperties = rocketBinderConfigurationProperties;
        this.instrumentationManager = instrumentationManager;
    }

    public void start() {
        if (((RocketMQProducerProperties)this.producerProperties.getExtension()).getTransactional().booleanValue()) {
            this.producer = new TransactionMQProducer(this.destination);
            if (this.transactionCheckListener != null) {
                ((TransactionMQProducer)this.producer).setTransactionCheckListener(this.transactionCheckListener);
            }
        } else {
            this.producer = new DefaultMQProducer(this.destination);
        }
        Optional.ofNullable(this.instrumentationManager).ifPresent(manager -> {
            this.producerInstrumentation = manager.getProducerInstrumentation(this.destination);
            manager.addHealthInstrumentation(this.producerInstrumentation);
        });
        this.producer.setNamesrvAddr(this.rocketBinderConfigurationProperties.getNamesrvAddr());
        if (((RocketMQProducerProperties)this.producerProperties.getExtension()).getMaxMessageSize() > 0) {
            this.producer.setMaxMessageSize(((RocketMQProducerProperties)this.producerProperties.getExtension()).getMaxMessageSize().intValue());
        }
        try {
            this.producer.start();
            Optional.ofNullable(this.producerInstrumentation).ifPresent(p -> p.markStartedSuccessfully());
        }
        catch (MQClientException e) {
            Optional.ofNullable(this.producerInstrumentation).ifPresent(p -> p.markStartFailed((Exception)((Object)e)));
            this.logger.error((Object)("RocketMQ Message hasn't been sent. Caused by " + e.getMessage()));
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
        this.running = true;
    }

    public void stop() {
        if (this.producer != null) {
            this.producer.shutdown();
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void handleMessageInternal(org.springframework.messaging.Message<?> message) throws Exception {
        try {
            Message toSend;
            if (message.getPayload() instanceof byte[]) {
                toSend = new Message(this.destination, (byte[])message.getPayload());
            } else if (message.getPayload() instanceof String) {
                toSend = new Message(this.destination, ((String)message.getPayload()).getBytes());
            } else {
                throw new UnsupportedOperationException("Payload class isn't supported: " + message.getPayload().getClass());
            }
            RocketMQMessageHeaderAccessor headerAccessor = new RocketMQMessageHeaderAccessor(message);
            headerAccessor.setLeaveMutable(true);
            toSend.setDelayTimeLevel(headerAccessor.getDelayTimeLevel().intValue());
            toSend.setTags(headerAccessor.getTags());
            toSend.setKeys(headerAccessor.getKeys());
            toSend.setFlag(headerAccessor.getFlag().intValue());
            for (Map.Entry<String, String> entry : headerAccessor.getUserProperties().entrySet()) {
                toSend.putUserProperty(entry.getKey(), entry.getValue());
            }
            Object sendRes = ((RocketMQProducerProperties)this.producerProperties.getExtension()).getTransactional() != false ? this.producer.sendMessageInTransaction(toSend, this.localTransactionExecuter, headerAccessor.getTransactionalArg()) : this.producer.send(toSend);
            if (!sendRes.getSendStatus().equals((Object)SendStatus.SEND_OK)) {
                throw new MQClientException("message hasn't been sent", null);
            }
            if (message instanceof MutableMessage) {
                RocketMQMessageHeaderAccessor.putSendResult((MutableMessage)message, sendRes);
            }
            Optional.ofNullable(this.instrumentationManager).ifPresent(manager -> manager.getRuntime().put("lastSend.timestamp", Instant.now().toEpochMilli()));
            Optional.ofNullable(this.producerInstrumentation).ifPresent(p -> p.markSent());
        }
        catch (InterruptedException | UnsupportedOperationException | MQBrokerException | MQClientException | RemotingException e) {
            Optional.ofNullable(this.producerInstrumentation).ifPresent(p -> p.markSentFailure());
            this.logger.error((Object)("RocketMQ Message hasn't been sent. Caused by " + e.getMessage()));
            throw new MessagingException(e.getMessage(), e);
        }
    }

    public void setLocalTransactionExecuter(LocalTransactionExecuter localTransactionExecuter) {
        this.localTransactionExecuter = localTransactionExecuter;
    }

    public void setTransactionCheckListener(TransactionCheckListener transactionCheckListener) {
        this.transactionCheckListener = transactionCheckListener;
    }
}

