/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rocketmq.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import org.springframework.cloud.stream.binder.rocketmq.metrics.Instrumentation;

public class ConsumerInstrumentation
extends Instrumentation {
    private final Counter totalConsumed;
    private final Counter totalConsumedFailures;
    private final Meter consumedPerSecond;
    private final Meter consumedFailuresPerSecond;

    public ConsumerInstrumentation(MetricRegistry registry, String baseMetricName) {
        super(baseMetricName);
        this.totalConsumed = registry.counter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"totalConsumed"}));
        this.consumedPerSecond = registry.meter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"consumedPerSecond"}));
        this.totalConsumedFailures = registry.counter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"totalConsumedFailures"}));
        this.consumedFailuresPerSecond = registry.meter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"consumedFailuresPerSecond"}));
    }

    public void markConsumed() {
        this.totalConsumed.inc();
        this.consumedPerSecond.mark();
    }

    public void markConsumedFailure() {
        this.totalConsumedFailures.inc();
        this.consumedFailuresPerSecond.mark();
    }
}

