/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rocketmq.metrics;

import com.codahale.metrics.MetricRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.cloud.stream.binder.rocketmq.metrics.ConsumerGroupInstrumentation;
import org.springframework.cloud.stream.binder.rocketmq.metrics.ConsumerInstrumentation;
import org.springframework.cloud.stream.binder.rocketmq.metrics.Instrumentation;
import org.springframework.cloud.stream.binder.rocketmq.metrics.ProducerInstrumentation;

public class InstrumentationManager {
    private final MetricRegistry metricRegistry = new MetricRegistry();
    private final Map<String, Object> runtime = new ConcurrentHashMap<String, Object>();
    private final Map<String, ProducerInstrumentation> producerInstrumentations = new HashMap<String, ProducerInstrumentation>();
    private final Map<String, ConsumerInstrumentation> consumeInstrumentations = new HashMap<String, ConsumerInstrumentation>();
    private final Map<String, ConsumerGroupInstrumentation> consumerGroupsInstrumentations = new HashMap<String, ConsumerGroupInstrumentation>();
    private final Map<String, Instrumentation> healthInstrumentations = new HashMap<String, Instrumentation>();

    public ProducerInstrumentation getProducerInstrumentation(String destination) {
        String key = "scs-rocketmq.producer." + destination;
        this.producerInstrumentations.putIfAbsent(key, new ProducerInstrumentation(this.metricRegistry, key));
        return this.producerInstrumentations.get(key);
    }

    public ConsumerInstrumentation getConsumerInstrumentation(String destination) {
        String key = "scs-rocketmq.consumer." + destination;
        this.consumeInstrumentations.putIfAbsent(key, new ConsumerInstrumentation(this.metricRegistry, key));
        return this.consumeInstrumentations.get(key);
    }

    public ConsumerGroupInstrumentation getConsumerGroupInstrumentation(String group) {
        String key = "scs-rocketmq.consumerGroup." + group;
        this.consumerGroupsInstrumentations.putIfAbsent(key, new ConsumerGroupInstrumentation(this.metricRegistry, key));
        return this.consumerGroupsInstrumentations.get(key);
    }

    public Set<Instrumentation> getHealthInstrumentations() {
        return this.healthInstrumentations.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    public void addHealthInstrumentation(Instrumentation instrumentation) {
        this.healthInstrumentations.put(instrumentation.getName(), instrumentation);
    }

    public Map<String, Object> getRuntime() {
        return this.runtime;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }
}

