/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rocketmq.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import org.springframework.cloud.stream.binder.rocketmq.metrics.Instrumentation;

public class ProducerInstrumentation
extends Instrumentation {
    private final Counter totalSent;
    private final Counter totalSentFailures;
    private final Meter sentPerSecond;
    private final Meter sentFailuresPerSecond;

    public ProducerInstrumentation(MetricRegistry registry, String baseMetricName) {
        super(baseMetricName);
        this.totalSent = registry.counter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"totalSent"}));
        this.totalSentFailures = registry.counter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"totalSentFailures"}));
        this.sentPerSecond = registry.meter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"sentPerSecond"}));
        this.sentFailuresPerSecond = registry.meter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"sentFailuresPerSecond"}));
    }

    public void markSent() {
        this.totalSent.inc();
        this.sentPerSecond.mark();
    }

    public void markSentFailure() {
        this.totalSentFailures.inc();
        this.sentFailuresPerSecond.mark();
    }
}

