/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rocketmq.properties;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.binder.ExtendedBindingProperties;
import org.springframework.cloud.stream.binder.rocketmq.properties.RocketMQBindingProperties;
import org.springframework.cloud.stream.binder.rocketmq.properties.RocketMQConsumerProperties;
import org.springframework.cloud.stream.binder.rocketmq.properties.RocketMQProducerProperties;

@ConfigurationProperties(value="spring.cloud.stream.rocketmq")
public class RocketMQExtendedBindingProperties
implements ExtendedBindingProperties<RocketMQConsumerProperties, RocketMQProducerProperties> {
    private Map<String, RocketMQBindingProperties> bindings = new HashMap<String, RocketMQBindingProperties>();

    public Map<String, RocketMQBindingProperties> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, RocketMQBindingProperties> bindings) {
        this.bindings = bindings;
    }

    public synchronized RocketMQConsumerProperties getExtendedConsumerProperties(String channelName) {
        if (this.bindings.containsKey(channelName)) {
            if (this.bindings.get(channelName).getConsumer() != null) {
                return this.bindings.get(channelName).getConsumer();
            }
            RocketMQConsumerProperties properties = new RocketMQConsumerProperties();
            this.bindings.get(channelName).setConsumer(properties);
            return properties;
        }
        RocketMQConsumerProperties properties = new RocketMQConsumerProperties();
        RocketMQBindingProperties rbp = new RocketMQBindingProperties();
        rbp.setConsumer(properties);
        this.bindings.put(channelName, rbp);
        return properties;
    }

    public synchronized RocketMQProducerProperties getExtendedProducerProperties(String channelName) {
        if (this.bindings.containsKey(channelName)) {
            if (this.bindings.get(channelName).getProducer() != null) {
                return this.bindings.get(channelName).getProducer();
            }
            RocketMQProducerProperties properties = new RocketMQProducerProperties();
            this.bindings.get(channelName).setProducer(properties);
            return properties;
        }
        RocketMQProducerProperties properties = new RocketMQProducerProperties();
        RocketMQBindingProperties rbp = new RocketMQBindingProperties();
        rbp.setProducer(properties);
        this.bindings.put(channelName, rbp);
        return properties;
    }
}

