/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;
import org.springframework.cloud.stream.binder.AbstractBinder;
import org.springframework.cloud.stream.binder.AbstractTestBinder;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binder.TestUtils;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.PollableChannel;

public abstract class AbstractBinderTests<B extends AbstractTestBinder<? extends AbstractBinder<MessageChannel, CP, PP>, CP, PP>, CP extends ConsumerProperties, PP extends ProducerProperties> {
    protected B testBinder;
    protected double timeoutMultiplier = 1.0;

    protected Message<?> receive(PollableChannel channel) {
        return this.receive(channel, 1);
    }

    protected Message<?> receive(PollableChannel channel, int additionalMultiplier) {
        return channel.receive((long)((int)(1000.0 * this.timeoutMultiplier * (double)additionalMultiplier)));
    }

    @Test
    public void testClean() throws Exception {
        B binder = this.getBinder();
        Binding foo0ProducerBinding = binder.bindProducer("foo.0", (Object)new DirectChannel(), this.createProducerProperties());
        Binding foo0ConsumerBinding = binder.bindConsumer("foo.0", "test", (Object)new DirectChannel(), this.createConsumerProperties());
        Binding foo1ProducerBinding = binder.bindProducer("foo.1", (Object)new DirectChannel(), this.createProducerProperties());
        Binding foo1ConsumerBinding = binder.bindConsumer("foo.1", "test", (Object)new DirectChannel(), this.createConsumerProperties());
        Binding foo2ProducerBinding = binder.bindProducer("foo.2", (Object)new DirectChannel(), this.createProducerProperties());
        foo0ProducerBinding.unbind();
        Assertions.assertThat((boolean)TestUtils.getPropertyValue(foo0ProducerBinding, "endpoint", AbstractEndpoint.class).isRunning()).isFalse();
        foo0ConsumerBinding.unbind();
        foo1ProducerBinding.unbind();
        Assertions.assertThat((boolean)TestUtils.getPropertyValue(foo0ConsumerBinding, "endpoint", AbstractEndpoint.class).isRunning()).isFalse();
        Assertions.assertThat((boolean)TestUtils.getPropertyValue(foo1ProducerBinding, "endpoint", AbstractEndpoint.class).isRunning()).isFalse();
        foo1ConsumerBinding.unbind();
        foo2ProducerBinding.unbind();
        Assertions.assertThat((boolean)TestUtils.getPropertyValue(foo1ConsumerBinding, "endpoint", AbstractEndpoint.class).isRunning()).isFalse();
        Assertions.assertThat((boolean)TestUtils.getPropertyValue(foo2ProducerBinding, "endpoint", AbstractEndpoint.class).isRunning()).isFalse();
    }

    @Test
    public void testSendAndReceive() throws Exception {
        B binder = this.getBinder();
        DirectChannel moduleOutputChannel = new DirectChannel();
        QueueChannel moduleInputChannel = new QueueChannel();
        Binding producerBinding = binder.bindProducer("foo.0", (Object)moduleOutputChannel, this.createProducerProperties());
        Binding consumerBinding = binder.bindConsumer("foo.0", "test", (Object)moduleInputChannel, this.createConsumerProperties());
        Message message = MessageBuilder.withPayload((Object)"foo").setHeader("contentType", (Object)"foo/bar").build();
        this.binderBindUnbindLatency();
        moduleOutputChannel.send(message);
        Message<?> inbound = this.receive((PollableChannel)moduleInputChannel);
        Assertions.assertThat(inbound).isNotNull();
        Assertions.assertThat((Object)inbound.getPayload()).isEqualTo((Object)"foo");
        Assertions.assertThat((Object)inbound.getHeaders().get((Object)"originalContentType")).isNull();
        Assertions.assertThat((Object)inbound.getHeaders().get((Object)"contentType")).isEqualTo((Object)"foo/bar");
        producerBinding.unbind();
        consumerBinding.unbind();
    }

    @Test
    public void testSendAndReceiveMultipleTopics() throws Exception {
        B binder = this.getBinder();
        DirectChannel moduleOutputChannel1 = new DirectChannel();
        DirectChannel moduleOutputChannel2 = new DirectChannel();
        QueueChannel moduleInputChannel = new QueueChannel();
        Binding producerBinding1 = binder.bindProducer("foo.x", (Object)moduleOutputChannel1, this.createProducerProperties());
        Binding producerBinding2 = binder.bindProducer("foo.y", (Object)moduleOutputChannel2, this.createProducerProperties());
        Binding consumerBinding1 = binder.bindConsumer("foo.x", "test", (Object)moduleInputChannel, this.createConsumerProperties());
        Binding consumerBinding2 = binder.bindConsumer("foo.y", "test", (Object)moduleInputChannel, this.createConsumerProperties());
        String testPayload1 = "foo" + UUID.randomUUID().toString();
        Message message1 = MessageBuilder.withPayload((Object)testPayload1.getBytes()).build();
        String testPayload2 = "foo" + UUID.randomUUID().toString();
        Message message2 = MessageBuilder.withPayload((Object)testPayload2.getBytes()).build();
        this.binderBindUnbindLatency();
        moduleOutputChannel1.send(message1);
        moduleOutputChannel2.send(message2);
        Object[] messages = new Message[]{this.receive((PollableChannel)moduleInputChannel), this.receive((PollableChannel)moduleInputChannel)};
        Assertions.assertThat((Object)messages[0]).isNotNull();
        Assertions.assertThat((Object)messages[1]).isNotNull();
        Assertions.assertThat((Object[])messages).extracting("payload").containsExactlyInAnyOrder(new Object[]{testPayload1.getBytes(), testPayload2.getBytes()});
        producerBinding1.unbind();
        producerBinding2.unbind();
        consumerBinding1.unbind();
        consumerBinding2.unbind();
    }

    @Test
    public void testSendAndReceiveNoOriginalContentType() throws Exception {
        B binder = this.getBinder();
        DirectChannel moduleOutputChannel = new DirectChannel();
        QueueChannel moduleInputChannel = new QueueChannel();
        Binding producerBinding = binder.bindProducer("bar.0", (Object)moduleOutputChannel, this.createProducerProperties());
        Binding consumerBinding = binder.bindConsumer("bar.0", "test", (Object)moduleInputChannel, this.createConsumerProperties());
        this.binderBindUnbindLatency();
        Message message = MessageBuilder.withPayload((Object)"foo").build();
        moduleOutputChannel.send(message);
        Message<?> inbound = this.receive((PollableChannel)moduleInputChannel);
        Assertions.assertThat(inbound).isNotNull();
        Assertions.assertThat((Object)inbound.getPayload()).isEqualTo((Object)"foo");
        Assertions.assertThat((Object)inbound.getHeaders().get((Object)"originalContentType")).isNull();
        Assertions.assertThat((Object)inbound.getHeaders().get((Object)"contentType")).isEqualTo((Object)"text/plain");
        producerBinding.unbind();
        consumerBinding.unbind();
    }

    protected abstract B getBinder() throws Exception;

    protected abstract CP createConsumerProperties();

    protected abstract PP createProducerProperties();

    @After
    public void cleanup() {
        if (this.testBinder != null) {
            ((AbstractTestBinder)this.testBinder).cleanup();
        }
    }

    protected void binderBindUnbindLatency() throws InterruptedException {
    }
}

