/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.util.HashSet;
import java.util.Set;
import org.springframework.cloud.stream.binder.AbstractBinder;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.messaging.MessageChannel;

public abstract class AbstractTestBinder<C extends AbstractBinder<MessageChannel, CP, PP>, CP extends ConsumerProperties, PP extends ProducerProperties>
implements Binder<MessageChannel, CP, PP> {
    protected Set<String> queues = new HashSet<String>();
    private C binder;

    public void setBinder(C binder) {
        try {
            binder.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize binder", e);
        }
        this.binder = binder;
    }

    public Binding<MessageChannel> bindConsumer(String name, String group, MessageChannel moduleInputChannel, CP properties) {
        this.queues.add(name);
        return this.binder.bindConsumer(name, group, (Object)moduleInputChannel, properties);
    }

    public Binding<MessageChannel> bindProducer(String name, MessageChannel moduleOutputChannel, PP properties) {
        this.queues.add(name);
        return this.binder.bindProducer(name, (Object)moduleOutputChannel, properties);
    }

    public C getCoreBinder() {
        return this.binder;
    }

    public abstract void cleanup();

    public C getBinder() {
        return this.binder;
    }
}

