/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.Test;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.cloud.stream.binder.AbstractBinder;
import org.springframework.cloud.stream.binder.AbstractBinderTests;
import org.springframework.cloud.stream.binder.AbstractTestBinder;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.PartitionTestSupport;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.context.Lifecycle;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.IntegrationMessageHeaderAccessor;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.support.GenericMessage;

public abstract class PartitionCapableBinderTests<B extends AbstractTestBinder<? extends AbstractBinder<MessageChannel, CP, PP>, CP, PP>, CP extends ConsumerProperties, PP extends ProducerProperties>
extends AbstractBinderTests<B, CP, PP> {
    protected static final SpelExpressionParser spelExpressionParser = new SpelExpressionParser();

    @Test
    public void testAnonymousGroup() throws Exception {
        Object binder = this.getBinder();
        BindingProperties producerBindingProperties = this.createProducerBindingProperties(this.createProducerProperties());
        DirectChannel output = this.createBindableChannel("output", producerBindingProperties);
        Binding<MessageChannel> producerBinding = ((AbstractTestBinder)binder).bindProducer("defaultGroup.0", (MessageChannel)output, (ProducerProperties)producerBindingProperties.getProducer());
        QueueChannel input1 = new QueueChannel();
        Binding<MessageChannel> binding1 = ((AbstractTestBinder)binder).bindConsumer("defaultGroup.0", null, (MessageChannel)input1, this.createConsumerProperties());
        QueueChannel input2 = new QueueChannel();
        Binding<MessageChannel> binding2 = ((AbstractTestBinder)binder).bindConsumer("defaultGroup.0", null, (MessageChannel)input2, this.createConsumerProperties());
        String testPayload1 = "foo-" + UUID.randomUUID().toString();
        output.send((Message)new GenericMessage((Object)testPayload1.getBytes()));
        Message<?> receivedMessage1 = this.receive((PollableChannel)input1);
        Assertions.assertThat(receivedMessage1).isNotNull();
        Assertions.assertThat((String)new String((byte[])receivedMessage1.getPayload())).isEqualTo((Object)testPayload1);
        Message<?> receivedMessage2 = this.receive((PollableChannel)input2);
        Assertions.assertThat(receivedMessage2).isNotNull();
        Assertions.assertThat((String)new String((byte[])receivedMessage2.getPayload())).isEqualTo((Object)testPayload1);
        binding2.unbind();
        String testPayload2 = "foo-" + UUID.randomUUID().toString();
        output.send((Message)new GenericMessage((Object)testPayload2.getBytes()));
        binding2 = ((AbstractTestBinder)binder).bindConsumer("defaultGroup.0", null, (MessageChannel)input2, this.createConsumerProperties());
        String testPayload3 = "foo-" + UUID.randomUUID().toString();
        output.send((Message)new GenericMessage((Object)testPayload3.getBytes()));
        receivedMessage1 = this.receive((PollableChannel)input1);
        Assertions.assertThat(receivedMessage1).isNotNull();
        Assertions.assertThat((String)new String((byte[])receivedMessage1.getPayload())).isEqualTo((Object)testPayload2);
        receivedMessage1 = this.receive((PollableChannel)input1);
        Assertions.assertThat(receivedMessage1).isNotNull();
        Assertions.assertThat((String)new String((byte[])receivedMessage1.getPayload())).isNotNull();
        receivedMessage2 = this.receive((PollableChannel)input2);
        Assertions.assertThat(receivedMessage2).isNotNull();
        Assertions.assertThat((String)new String((byte[])receivedMessage2.getPayload())).isEqualTo((Object)testPayload3);
        producerBinding.unbind();
        binding1.unbind();
        binding2.unbind();
    }

    @Test
    public void testOneRequiredGroup() throws Exception {
        Object binder = this.getBinder();
        Object producerProperties = this.createProducerProperties();
        DirectChannel output = this.createBindableChannel("output", this.createProducerBindingProperties(producerProperties));
        String testDestination = "testDestination" + UUID.randomUUID().toString().replace("-", "");
        producerProperties.setRequiredGroups(new String[]{"test1"});
        Binding<MessageChannel> producerBinding = ((AbstractTestBinder)binder).bindProducer(testDestination, (MessageChannel)output, producerProperties);
        String testPayload = "foo-" + UUID.randomUUID().toString();
        output.send((Message)new GenericMessage((Object)testPayload.getBytes()));
        QueueChannel inbound1 = new QueueChannel();
        Binding<MessageChannel> consumerBinding = ((AbstractTestBinder)binder).bindConsumer(testDestination, "test1", (MessageChannel)inbound1, this.createConsumerProperties());
        Message<?> receivedMessage1 = this.receive((PollableChannel)inbound1);
        Assertions.assertThat(receivedMessage1).isNotNull();
        Assertions.assertThat((String)new String((byte[])receivedMessage1.getPayload())).isEqualTo((Object)testPayload);
        producerBinding.unbind();
        consumerBinding.unbind();
    }

    @Test
    public void testTwoRequiredGroups() throws Exception {
        Object binder = this.getBinder();
        Object producerProperties = this.createProducerProperties();
        DirectChannel output = this.createBindableChannel("output", this.createProducerBindingProperties(producerProperties));
        String testDestination = "testDestination" + UUID.randomUUID().toString().replace("-", "");
        producerProperties.setRequiredGroups(new String[]{"test1", "test2"});
        Binding<MessageChannel> producerBinding = ((AbstractTestBinder)binder).bindProducer(testDestination, (MessageChannel)output, producerProperties);
        String testPayload = "foo-" + UUID.randomUUID().toString();
        output.send((Message)new GenericMessage((Object)testPayload.getBytes()));
        QueueChannel inbound1 = new QueueChannel();
        Binding<MessageChannel> consumerBinding1 = ((AbstractTestBinder)binder).bindConsumer(testDestination, "test1", (MessageChannel)inbound1, this.createConsumerProperties());
        QueueChannel inbound2 = new QueueChannel();
        Binding<MessageChannel> consumerBinding2 = ((AbstractTestBinder)binder).bindConsumer(testDestination, "test2", (MessageChannel)inbound2, this.createConsumerProperties());
        Message<?> receivedMessage1 = this.receive((PollableChannel)inbound1);
        Assertions.assertThat(receivedMessage1).isNotNull();
        Assertions.assertThat((String)new String((byte[])receivedMessage1.getPayload())).isEqualTo((Object)testPayload);
        Message<?> receivedMessage2 = this.receive((PollableChannel)inbound2);
        Assertions.assertThat(receivedMessage2).isNotNull();
        Assertions.assertThat((String)new String((byte[])receivedMessage2.getPayload())).isEqualTo((Object)testPayload);
        consumerBinding1.unbind();
        consumerBinding2.unbind();
        producerBinding.unbind();
    }

    @Test
    public void testPartitionedModuleSpEL() throws Exception {
        Object binder = this.getBinder();
        Object consumerProperties = this.createConsumerProperties();
        consumerProperties.setConcurrency(2);
        consumerProperties.setInstanceIndex(0);
        consumerProperties.setInstanceCount(3);
        consumerProperties.setPartitioned(true);
        QueueChannel input0 = new QueueChannel();
        input0.setBeanName("test.input0S");
        Binding<MessageChannel> input0Binding = ((AbstractTestBinder)binder).bindConsumer("part.0", "test", (MessageChannel)input0, consumerProperties);
        consumerProperties.setInstanceIndex(1);
        QueueChannel input1 = new QueueChannel();
        input1.setBeanName("test.input1S");
        Binding<MessageChannel> input1Binding = ((AbstractTestBinder)binder).bindConsumer("part.0", "test", (MessageChannel)input1, consumerProperties);
        consumerProperties.setInstanceIndex(2);
        QueueChannel input2 = new QueueChannel();
        input2.setBeanName("test.input2S");
        Binding<MessageChannel> input2Binding = ((AbstractTestBinder)binder).bindConsumer("part.0", "test", (MessageChannel)input2, consumerProperties);
        Object producerProperties = this.createProducerProperties();
        producerProperties.setPartitionKeyExpression(spelExpressionParser.parseExpression("payload"));
        producerProperties.setPartitionSelectorExpression(spelExpressionParser.parseExpression("hashCode()"));
        producerProperties.setPartitionCount(3);
        DirectChannel output = this.createBindableChannel("output", this.createProducerBindingProperties(producerProperties));
        output.setBeanName("test.output");
        Binding<MessageChannel> outputBinding = ((AbstractTestBinder)binder).bindProducer("part.0", (MessageChannel)output, producerProperties);
        try {
            Lifecycle endpoint = this.extractEndpoint(outputBinding);
            Assertions.assertThat((String)this.getEndpointRouting(endpoint)).contains(new CharSequence[]{this.getExpectedRoutingBaseDestination("part.0", "test") + "-' + headers['partition']"});
        }
        catch (UnsupportedOperationException endpoint) {
            // empty catch block
        }
        Message message2 = MessageBuilder.withPayload((Object)2).setHeader("correlationId", (Object)"foo").setHeader("sequenceNumber", (Object)42).setHeader("sequenceSize", (Object)43).build();
        output.send(message2);
        output.send((Message)new GenericMessage((Object)1));
        output.send((Message)new GenericMessage((Object)0));
        Message<?> receive0 = this.receive((PollableChannel)input0);
        Assertions.assertThat(receive0).isNotNull();
        Message<?> receive1 = this.receive((PollableChannel)input1);
        Assertions.assertThat(receive1).isNotNull();
        Message<?> receive2 = this.receive((PollableChannel)input2);
        Assertions.assertThat(receive2).isNotNull();
        Condition correlationHeadersForPayload2 = new Condition<Message<?>>(){

            public boolean matches(Message<?> value) {
                IntegrationMessageHeaderAccessor accessor = new IntegrationMessageHeaderAccessor(value);
                return "foo".equals(accessor.getCorrelationId()) && 42 == accessor.getSequenceNumber() && 43 == accessor.getSequenceSize();
            }
        };
        if (this.usesExplicitRouting()) {
            Assertions.assertThat((Object)receive0.getPayload()).isEqualTo((Object)0);
            Assertions.assertThat((Object)receive1.getPayload()).isEqualTo((Object)1);
            Assertions.assertThat((Object)receive2.getPayload()).isEqualTo((Object)2);
            Assertions.assertThat(receive2).has(correlationHeadersForPayload2);
        } else {
            List<Message> receivedMessages = Arrays.asList(receive0, receive1, receive2);
            Assertions.assertThat(receivedMessages).extracting("payload").containsExactlyInAnyOrder(new Object[]{0, 1, 2});
            Condition payloadIs2 = new Condition<Message<?>>(){

                public boolean matches(Message<?> value) {
                    return value.getPayload().equals(2);
                }
            };
            ((AbstractListAssert)Assertions.assertThat(receivedMessages).filteredOn(payloadIs2)).areExactly(1, correlationHeadersForPayload2);
        }
        input0Binding.unbind();
        input1Binding.unbind();
        input2Binding.unbind();
        outputBinding.unbind();
    }

    @Test
    public void testPartitionedModuleJava() throws Exception {
        Object binder = this.getBinder();
        Object consumerProperties = this.createConsumerProperties();
        consumerProperties.setConcurrency(2);
        consumerProperties.setInstanceCount(3);
        consumerProperties.setInstanceIndex(0);
        consumerProperties.setPartitioned(true);
        QueueChannel input0 = new QueueChannel();
        input0.setBeanName("test.input0J");
        Binding<MessageChannel> input0Binding = ((AbstractTestBinder)binder).bindConsumer("partJ.0", "test", (MessageChannel)input0, consumerProperties);
        consumerProperties.setInstanceIndex(1);
        QueueChannel input1 = new QueueChannel();
        input1.setBeanName("test.input1J");
        Binding<MessageChannel> input1Binding = ((AbstractTestBinder)binder).bindConsumer("partJ.0", "test", (MessageChannel)input1, consumerProperties);
        consumerProperties.setInstanceIndex(2);
        QueueChannel input2 = new QueueChannel();
        input2.setBeanName("test.input2J");
        Binding<MessageChannel> input2Binding = ((AbstractTestBinder)binder).bindConsumer("partJ.0", "test", (MessageChannel)input2, consumerProperties);
        Object producerProperties = this.createProducerProperties();
        producerProperties.setPartitionKeyExtractorClass(PartitionTestSupport.class);
        producerProperties.setPartitionSelectorClass(PartitionTestSupport.class);
        producerProperties.setPartitionCount(3);
        DirectChannel output = this.createBindableChannel("output", this.createProducerBindingProperties(producerProperties));
        output.setBeanName("test.output");
        Binding<MessageChannel> outputBinding = ((AbstractTestBinder)binder).bindProducer("partJ.0", (MessageChannel)output, producerProperties);
        if (this.usesExplicitRouting()) {
            Lifecycle endpoint = this.extractEndpoint(outputBinding);
            Assertions.assertThat((String)this.getEndpointRouting(endpoint)).contains(new CharSequence[]{this.getExpectedRoutingBaseDestination("partJ.0", "test") + "-' + headers['partition']"});
        }
        output.send((Message)new GenericMessage((Object)2));
        output.send((Message)new GenericMessage((Object)1));
        output.send((Message)new GenericMessage((Object)0));
        Message<?> receive0 = this.receive((PollableChannel)input0);
        Assertions.assertThat(receive0).isNotNull();
        Message<?> receive1 = this.receive((PollableChannel)input1);
        Assertions.assertThat(receive1).isNotNull();
        Message<?> receive2 = this.receive((PollableChannel)input2);
        Assertions.assertThat(receive2).isNotNull();
        if (this.usesExplicitRouting()) {
            Assertions.assertThat((Object)receive0.getPayload()).isEqualTo((Object)0);
            Assertions.assertThat((Object)receive1.getPayload()).isEqualTo((Object)1);
            Assertions.assertThat((Object)receive2.getPayload()).isEqualTo((Object)2);
        } else {
            List<Message> receivedMessages = Arrays.asList(receive0, receive1, receive2);
            Assertions.assertThat(receivedMessages).extracting("payload").containsExactlyInAnyOrder(new Object[]{0, 1, 2});
        }
        input0Binding.unbind();
        input1Binding.unbind();
        input2Binding.unbind();
        outputBinding.unbind();
    }

    protected abstract boolean usesExplicitRouting();

    protected String getEndpointRouting(Object endpoint) {
        throw new UnsupportedOperationException();
    }

    protected String getExpectedRoutingBaseDestination(String name, String group) {
        throw new UnsupportedOperationException();
    }

    protected abstract String getClassUnderTestName();

    protected Lifecycle extractEndpoint(Binding<MessageChannel> binding) {
        DirectFieldAccessor accessor = new DirectFieldAccessor(binding);
        return (Lifecycle)accessor.getPropertyValue("lifecycle");
    }
}

