/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config.codec.kryo;

import com.esotericsoftware.kryo.Kryo;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.config.codec.kryo.KryoCodecProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.codec.Codec;
import org.springframework.integration.codec.kryo.FileKryoRegistrar;
import org.springframework.integration.codec.kryo.KryoRegistrar;
import org.springframework.integration.codec.kryo.PojoCodec;

@Configuration
@ConditionalOnClass(value={Kryo.class})
@EnableConfigurationProperties(value={KryoCodecProperties.class})
@ConditionalOnMissingBean(value={Codec.class})
public class KryoCodecAutoConfiguration {
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    KryoCodecProperties kryoCodecProperties;

    @Bean
    @ConditionalOnMissingBean(value={PojoCodec.class})
    public PojoCodec codec() {
        Map kryoRegistrarMap = this.applicationContext.getBeansOfType(KryoRegistrar.class);
        return new PojoCodec(new ArrayList(kryoRegistrarMap.values()), this.kryoCodecProperties.isReferences());
    }

    @Bean
    @ConditionalOnMissingBean(value={KryoRegistrar.class})
    public KryoRegistrar fileRegistrar() {
        return new FileKryoRegistrar();
    }
}

