/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.reactive;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.cloud.stream.reactive.MessageChannelToFluxSenderParameterAdapter;
import org.springframework.cloud.stream.reactive.MessageChannelToInputFluxParameterAdapter;
import org.springframework.cloud.stream.reactive.MessageChannelToInputObservableParameterAdapter;
import org.springframework.cloud.stream.reactive.MessageChannelToObservableSenderParameterAdapter;
import org.springframework.cloud.stream.reactive.ObservableToMessageChannelResultAdapter;
import org.springframework.cloud.stream.reactive.PublisherToMessageChannelResultAdapter;
import org.springframework.cloud.stream.reactive.StreamEmitterAnnotationBeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={BindingService.class})
public class ReactiveSupportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={MessageChannelToInputFluxParameterAdapter.class})
    public MessageChannelToInputFluxParameterAdapter messageChannelToInputFluxArgumentAdapter(CompositeMessageConverterFactory compositeMessageConverterFactory) {
        return new MessageChannelToInputFluxParameterAdapter(compositeMessageConverterFactory.getMessageConverterForAllRegistered());
    }

    @Bean
    @ConditionalOnMissingBean(value={MessageChannelToFluxSenderParameterAdapter.class})
    public MessageChannelToFluxSenderParameterAdapter messageChannelToFluxSenderArgumentAdapter() {
        return new MessageChannelToFluxSenderParameterAdapter();
    }

    @Bean
    @ConditionalOnMissingBean(value={PublisherToMessageChannelResultAdapter.class})
    public PublisherToMessageChannelResultAdapter fluxToMessageChannelResultAdapter() {
        return new PublisherToMessageChannelResultAdapter();
    }

    @Bean
    public static StreamEmitterAnnotationBeanPostProcessor streamEmitterAnnotationBeanPostProcessor() {
        return new StreamEmitterAnnotationBeanPostProcessor();
    }

    @Configuration
    @ConditionalOnClass(name={"rx.Observable"})
    public static class RxJava1SupportConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={MessageChannelToInputObservableParameterAdapter.class})
        public MessageChannelToInputObservableParameterAdapter messageChannelToInputObservableArgumentAdapter(MessageChannelToInputFluxParameterAdapter messageChannelToFluxArgumentAdapter) {
            return new MessageChannelToInputObservableParameterAdapter(messageChannelToFluxArgumentAdapter);
        }

        @Bean
        @ConditionalOnMissingBean(value={MessageChannelToObservableSenderParameterAdapter.class})
        public MessageChannelToObservableSenderParameterAdapter messageChannelToObservableSenderArgumentAdapter(MessageChannelToFluxSenderParameterAdapter messageChannelToFluxSenderArgumentAdapter) {
            return new MessageChannelToObservableSenderParameterAdapter(messageChannelToFluxSenderArgumentAdapter);
        }

        @Bean
        @ConditionalOnMissingBean(value={ObservableToMessageChannelResultAdapter.class})
        public ObservableToMessageChannelResultAdapter observableToMessageChannelResultAdapter(PublisherToMessageChannelResultAdapter publisherToMessageChannelResultAdapter) {
            return new ObservableToMessageChannelResultAdapter(publisherToMessageChannelResultAdapter);
        }
    }
}

