/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.reactive.shaded.rx.internal.reactivestreams;

import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscription;
import org.springframework.cloud.stream.reactive.shaded.rx.internal.reactivestreams.RxJavaSynchronizedProducer;
import rx.Producer;
import rx.Subscriber;

public class SubscriberAdapter<T>
implements org.reactivestreams.Subscriber<T> {
    private final Subscriber<? super T> rxSubscriber;
    private final AtomicBoolean started = new AtomicBoolean();

    public SubscriberAdapter(Subscriber<? super T> rxSubscriber) {
        this.rxSubscriber = rxSubscriber;
    }

    public void onSubscribe(Subscription rsSubscription) {
        if (rsSubscription == null) {
            throw new NullPointerException("onSubscribe(null)");
        }
        if (this.started.compareAndSet(false, true)) {
            RxJavaSynchronizedProducer sp = new RxJavaSynchronizedProducer(rsSubscription);
            this.rxSubscriber.add((rx.Subscription)sp);
            this.rxSubscriber.setProducer((Producer)sp);
        } else {
            rsSubscription.cancel();
        }
    }

    public void onNext(T t) {
        if (t == null) {
            throw new NullPointerException("onNext(null)");
        }
        this.rxSubscriber.onNext(t);
    }

    public void onError(Throwable t) {
        if (t == null) {
            throw new NullPointerException("onError(null)");
        }
        this.rxSubscriber.onError(t);
    }

    public void onComplete() {
        this.rxSubscriber.onCompleted();
    }
}

