/*
 * Copyright 2016-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.stream.schema.server.repository;

import java.util.List;

import org.springframework.cloud.stream.schema.server.model.Schema;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author Vinicius Carvalho
 */
public interface SchemaRepository extends PagingAndSortingRepository<Schema, Integer> {

	@Transactional
	List<Schema> findBySubjectAndFormatOrderByVersion(String subject, String format);

	@Transactional
	Schema findOneBySubjectAndFormatAndVersion(String subject, String format,
			Integer version);

}
