/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema.avro;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.schema.avro.AvroSchemaServiceManager;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.stereotype.Component;

@Component
public class AvroSchemaServiceManagerImpl
implements AvroSchemaServiceManager {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public Schema getSchema(Class<?> clazz) {
        return ReflectData.get().getSchema(clazz);
    }

    public DatumWriter<Object> getDatumWriter(Class<?> type, Schema schema) {
        this.logger.debug((Object)("Finding correct DatumWriter for type " + type.getName()));
        Object writer = SpecificRecord.class.isAssignableFrom(type) ? (schema != null ? new SpecificDatumWriter(schema) : new SpecificDatumWriter(type)) : (GenericRecord.class.isAssignableFrom(type) ? new GenericDatumWriter(schema) : (schema != null ? new ReflectDatumWriter(schema) : new ReflectDatumWriter(type)));
        return writer;
    }

    public DatumReader<Object> getDatumReader(Class<?> type, Schema schema, Schema writerSchema) {
        SpecificDatumReader reader = null;
        if (SpecificRecord.class.isAssignableFrom(type)) {
            if (schema != null) {
                reader = writerSchema != null ? new SpecificDatumReader(writerSchema, schema) : new SpecificDatumReader(schema);
            } else {
                reader = new SpecificDatumReader(type);
                if (writerSchema != null) {
                    reader.setSchema(writerSchema);
                }
            }
        } else if (GenericRecord.class.isAssignableFrom(type)) {
            if (schema != null) {
                reader = writerSchema != null ? new GenericDatumReader(writerSchema, schema) : new GenericDatumReader(schema);
            }
        } else {
            reader = new ReflectDatumReader(type);
            if (writerSchema != null) {
                reader.setSchema(writerSchema);
            }
        }
        if (reader == null) {
            throw new MessageConversionException("No schema can be inferred from type " + type.getName() + " and no schema has been explicitly configured.");
        }
        return reader;
    }

    @Override
    public Object readData(Class<? extends Object> clazz, byte[] payload, Schema readerSchema, Schema writerSchema) throws IOException {
        DatumReader<Object> reader = this.getDatumReader((Class<?>)clazz, readerSchema, writerSchema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(payload, null);
        return reader.read(null, (Decoder)decoder);
    }
}

