/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;

@ConfigurationProperties(value="spring.integration.poller")
public class DefaultPollerProperties {
    private long fixedDelay = 1000L;
    private long maxMessagesPerPoll = 1L;

    public PollerMetadata getPollerMetadata() {
        PollerMetadata pollerMetadata = new PollerMetadata();
        pollerMetadata.setTrigger((Trigger)new PeriodicTrigger(this.fixedDelay));
        pollerMetadata.setMaxMessagesPerPoll(this.maxMessagesPerPoll);
        return pollerMetadata;
    }

    public long getFixedDelay() {
        return this.fixedDelay;
    }

    public void setFixedDelay(long fixedDelay) {
        this.fixedDelay = fixedDelay;
    }

    public long getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(long maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }
}

