/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import org.springframework.cloud.stream.binder.LastSubscriberAwareChannel;
import org.springframework.cloud.stream.binder.LastSubscriberMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

class FinalRethrowingErrorMessageHandler
implements MessageHandler,
LastSubscriberMessageHandler {
    private final LastSubscriberAwareChannel errorChannel;
    private final boolean defaultErrorChannelPresent;

    FinalRethrowingErrorMessageHandler(LastSubscriberAwareChannel errorChannel, boolean defaultErrorChannelPresent) {
        this.errorChannel = errorChannel;
        this.defaultErrorChannelPresent = defaultErrorChannelPresent;
    }

    public void handleMessage(Message<?> message) throws MessagingException {
        if (this.errorChannel.subscribers() > (this.defaultErrorChannelPresent ? 2 : 1)) {
            return;
        }
        if (message.getPayload() instanceof MessagingException) {
            throw (MessagingException)message.getPayload();
        }
        throw new MessagingException((Message)null, (Throwable)message.getPayload());
    }
}

