/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

public abstract class JavaClassMimeTypeUtils {
    private static ConcurrentMap<String, MimeType> mimeTypesCache = new ConcurrentHashMap<String, MimeType>();

    public static MimeType mimeTypeFromObject(Object payload, String originalContentType) {
        Assert.notNull((Object)payload, (String)"payload object cannot be null.");
        if (payload instanceof byte[]) {
            return MimeTypeUtils.APPLICATION_OCTET_STREAM;
        }
        if (payload instanceof String) {
            return "application/json".equals(originalContentType) ? MimeTypeUtils.APPLICATION_JSON : MimeTypeUtils.TEXT_PLAIN;
        }
        String className = payload.getClass().getName();
        MimeType mimeType = (MimeType)mimeTypesCache.get(className);
        if (mimeType == null) {
            String modifiedClassName = className;
            if (payload.getClass().isArray()) {
                if (modifiedClassName.endsWith(";")) {
                    modifiedClassName = modifiedClassName.substring(0, modifiedClassName.length() - 1);
                }
                modifiedClassName = "\"" + modifiedClassName + "\"";
            }
            mimeType = MimeType.valueOf((String)("application/x-java-object;type=" + modifiedClassName));
            mimeTypesCache.put(className, mimeType);
        }
        return mimeType;
    }

    public static String classNameFromMimeType(MimeType mimeType) {
        Assert.notNull((Object)mimeType, (String)"mimeType cannot be null.");
        String className = mimeType.getParameter("type");
        if (className == null) {
            return null;
        }
        if ((className = className.replace("\"", "")).contains("[L")) {
            className = className + ";";
        }
        return className;
    }
}

