/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.binder.BinderException;
import org.springframework.cloud.stream.binder.PartitionHandler;
import org.springframework.cloud.stream.binder.PartitionKeyExtractorStrategy;
import org.springframework.cloud.stream.binder.PartitionSelectorStrategy;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binding.MessageChannelConfigurer;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.cloud.stream.converter.MessageConverterUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.MutableMessageBuilderFactory;
import org.springframework.integration.support.MutableMessageHeaders;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.tuple.Tuple;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

public class MessageConverterConfigurer
implements MessageChannelConfigurer,
BeanFactoryAware,
InitializingBean {
    private final MessageBuilderFactory messageBuilderFactory = new MutableMessageBuilderFactory();
    private final CompositeMessageConverterFactory compositeMessageConverterFactory;
    private final BindingServiceProperties bindingServiceProperties;
    private ConfigurableListableBeanFactory beanFactory;

    public MessageConverterConfigurer(BindingServiceProperties bindingServiceProperties, CompositeMessageConverterFactory compositeMessageConverterFactory) {
        Assert.notNull((Object)compositeMessageConverterFactory, (String)"The message converter factory cannot be null");
        this.bindingServiceProperties = bindingServiceProperties;
        this.compositeMessageConverterFactory = compositeMessageConverterFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.beanFactory, (String)"Bean factory cannot be empty");
    }

    @Override
    public void configureInputChannel(MessageChannel messageChannel, String channelName) {
        this.configureMessageChannel(messageChannel, channelName, true);
    }

    @Override
    public void configureOutputChannel(MessageChannel messageChannel, String channelName) {
        this.configureMessageChannel(messageChannel, channelName, false);
    }

    private void configureMessageChannel(MessageChannel channel, String channelName, boolean input) {
        Assert.isAssignable(AbstractMessageChannel.class, channel.getClass());
        AbstractMessageChannel messageChannel = (AbstractMessageChannel)channel;
        BindingProperties bindingProperties = this.bindingServiceProperties.getBindingProperties(channelName);
        String contentType = bindingProperties.getContentType();
        ProducerProperties producerProperties = bindingProperties.getProducer();
        if (!input && producerProperties != null && producerProperties.isPartitioned()) {
            messageChannel.addInterceptor((ChannelInterceptor)new PartitioningInterceptor(bindingProperties, this.getPartitionKeyExtractorStrategy(producerProperties), this.getPartitionSelectorStrategy(producerProperties)));
        }
        if (StringUtils.hasText((String)contentType)) {
            messageChannel.addInterceptor((ChannelInterceptor)new ContentTypeConvertingInterceptor(contentType, input));
        }
    }

    private PartitionKeyExtractorStrategy getPartitionKeyExtractorStrategy(ProducerProperties producerProperties) {
        if (producerProperties.getPartitionKeyExtractorClass() != null) {
            return this.getBean(producerProperties.getPartitionKeyExtractorClass().getName(), PartitionKeyExtractorStrategy.class);
        }
        return null;
    }

    private PartitionSelectorStrategy getPartitionSelectorStrategy(ProducerProperties producerProperties) {
        if (producerProperties.getPartitionSelectorClass() != null) {
            return this.getBean(producerProperties.getPartitionSelectorClass().getName(), PartitionSelectorStrategy.class);
        }
        return new DefaultPartitionSelector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getBean(String className, Class<T> type) {
        if (this.beanFactory.containsBean(className)) {
            return (T)this.beanFactory.getBean(className, type);
        }
        MessageConverterConfigurer messageConverterConfigurer = this;
        synchronized (messageConverterConfigurer) {
            Object bean;
            Class clazz;
            try {
                clazz = ClassUtils.forName((String)className, (ClassLoader)this.beanFactory.getBeanClassLoader());
            }
            catch (Exception e) {
                throw new BinderException("Failed to load class: " + className, e);
            }
            try {
                bean = clazz.newInstance();
                Assert.isInstanceOf(type, bean);
                this.beanFactory.registerSingleton(className, bean);
                this.beanFactory.initializeBean(bean, className);
            }
            catch (Exception e) {
                throw new BinderException("Failed to instantiate class: " + className, e);
            }
            return bean;
        }
    }

    protected final class PartitioningInterceptor
    extends ChannelInterceptorAdapter {
        private final BindingProperties bindingProperties;
        private final PartitionHandler partitionHandler;

        PartitioningInterceptor(BindingProperties bindingProperties, PartitionKeyExtractorStrategy partitionKeyExtractorStrategy, PartitionSelectorStrategy partitionSelectorStrategy) {
            this.bindingProperties = bindingProperties;
            this.partitionHandler = new PartitionHandler((EvaluationContext)ExpressionUtils.createStandardEvaluationContext((BeanFactory)MessageConverterConfigurer.this.beanFactory), this.bindingProperties.getProducer(), partitionKeyExtractorStrategy, partitionSelectorStrategy);
        }

        public Message<?> preSend(Message<?> message, MessageChannel channel) {
            if (!message.getHeaders().containsKey((Object)"scst_partitionOverride")) {
                int partition = this.partitionHandler.determinePartition(message);
                return MessageConverterConfigurer.this.messageBuilderFactory.fromMessage(message).setHeader("scst_partition", (Object)partition).build();
            }
            return MessageConverterConfigurer.this.messageBuilderFactory.fromMessage(message).setHeader("scst_partition", message.getHeaders().get((Object)"scst_partitionOverride")).removeHeader("scst_partitionOverride").build();
        }
    }

    private final class ContentTypeConvertingInterceptor
    extends ChannelInterceptorAdapter {
        private final String contentType;
        private final MimeType mimeType;
        private final boolean input;
        private final Class<?> klazz;
        private final MessageConverter messageConverter;
        private final boolean provideHint;

        private ContentTypeConvertingInterceptor(String contentType, boolean input) {
            this.contentType = contentType;
            this.mimeType = MessageConverterUtils.getMimeType(contentType);
            this.input = input;
            this.klazz = MessageConverterUtils.X_JAVA_OBJECT.includes(this.mimeType) ? MessageConverterUtils.getJavaTypeForJavaObjectContentType(this.mimeType) : (this.mimeType.equals((Object)MessageConverterUtils.X_SPRING_TUPLE) ? Tuple.class : (this.mimeType.getType().equals("text") || this.mimeType.getSubtype().equals("json") || this.mimeType.getSubtype().equals("xml") ? String.class : byte[].class));
            this.messageConverter = MessageConverterConfigurer.this.compositeMessageConverterFactory.getMessageConverterForType(this.mimeType);
            this.provideHint = this.messageConverter instanceof AbstractMessageConverter;
        }

        public Message<?> preSend(Message<?> message, MessageChannel channel) {
            Message sentMessage = null;
            if (this.klazz.isAssignableFrom(message.getPayload().getClass()) || this.klazz.isAssignableFrom(String.class) && message.getPayload() instanceof byte[] && !message.getHeaders().containsKey((Object)"contentType") && !this.contentType.equals("text/plain")) {
                Object contentTypeFromMessage = message.getHeaders().get((Object)"contentType");
                sentMessage = contentTypeFromMessage == null ? MessageConverterConfigurer.this.messageBuilderFactory.fromMessage(message).setHeader("contentType", (Object)this.contentType).build() : message;
            } else {
                Object converted;
                if (this.input) {
                    if (this.provideHint) {
                        converted = ((AbstractMessageConverter)this.messageConverter).fromMessage(message, this.klazz, (Object)this.mimeType);
                        if (converted == null && message.getHeaders().containsKey((Object)"contentType")) {
                            converted = ((AbstractMessageConverter)this.messageConverter).fromMessage(MessageConverterConfigurer.this.messageBuilderFactory.fromMessage(message).removeHeader("contentType").build(), this.klazz, (Object)this.mimeType);
                        }
                    } else {
                        converted = this.messageConverter.fromMessage(message, this.klazz);
                        if (converted == null && message.getHeaders().containsKey((Object)"contentType")) {
                            converted = this.messageConverter.fromMessage(MessageConverterConfigurer.this.messageBuilderFactory.fromMessage(message).removeHeader("contentType").build(), this.klazz);
                        }
                    }
                } else {
                    MutableMessageHeaders headers = new MutableMessageHeaders((Map)message.getHeaders());
                    if (this.provideHint) {
                        converted = ((AbstractMessageConverter)this.messageConverter).toMessage(message.getPayload(), (MessageHeaders)headers, (Object)this.mimeType);
                        if (converted == null && message.getHeaders().containsKey((Object)"contentType")) {
                            headers.remove((Object)"contentType");
                            converted = ((AbstractMessageConverter)this.messageConverter).toMessage(message.getPayload(), (MessageHeaders)headers, (Object)this.mimeType);
                        }
                    } else {
                        converted = this.messageConverter.toMessage(message.getPayload(), (MessageHeaders)headers);
                        if (converted == null && message.getHeaders().containsKey((Object)"contentType")) {
                            headers.remove((Object)"contentType");
                            converted = this.messageConverter.toMessage(message.getPayload(), (MessageHeaders)headers);
                        }
                    }
                }
                if (converted != null) {
                    sentMessage = converted instanceof Message ? (Message)converted : MessageConverterConfigurer.this.messageBuilderFactory.withPayload(converted).copyHeaders((Map)message.getHeaders()).setHeaderIfAbsent("contentType", (Object)this.mimeType).build();
                }
            }
            if (sentMessage == null) {
                throw new MessageConversionException(message, this.messageConverter.getClass().toString() + " could not convert '" + message + "' to the configured output type: '" + this.contentType + "'");
            }
            return sentMessage;
        }
    }

    private static class DefaultPartitionSelector
    implements PartitionSelectorStrategy {
        private DefaultPartitionSelector() {
        }

        @Override
        public int selectPartition(Object key, int partitionCount) {
            int hashCode = key.hashCode();
            if (hashCode == Integer.MIN_VALUE) {
                hashCode = 0;
            }
            return Math.abs(hashCode);
        }
    }
}

