/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.test;

import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.annotation.Input;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.cloud.stream.binder.PollableMessageSource;
import org.springframework.cloud.stream.binder.test.InputDestination;
import org.springframework.cloud.stream.binder.test.OutputDestination;
import org.springframework.cloud.stream.binder.test.TestChannelBinderConfiguration;
import org.springframework.cloud.stream.messaging.Processor;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.support.GenericMessage;

@SpringBootApplication
@EnableBinding(value={PolledConsumer.class})
@Import(value={TestChannelBinderConfiguration.class})
public class SampleStreamApp {
    public static void main(String[] args) {
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{SampleStreamApp.class}).web(WebApplicationType.NONE).run(new String[]{"--server.port=0"});
        InputDestination source = (InputDestination)context.getBean(InputDestination.class);
        OutputDestination target = (OutputDestination)context.getBean(OutputDestination.class);
        source.send((Message<byte[]>)new GenericMessage((Object)"Hello".getBytes()));
        Message<byte[]> message = target.receive();
        Assertions.assertThat((String)new String((byte[])message.getPayload(), StandardCharsets.UTF_8)).isEqualTo((Object)"Hello");
    }

    @Bean
    public ApplicationRunner runner(PollableMessageSource pollableSource) {
        return args -> pollableSource.poll(message -> System.out.println("Polled payload: " + message.getPayload()));
    }

    @StreamListener(value="input")
    @SendTo(value={"output"})
    public String receive(String value) {
        System.out.println("Handling payload: " + value);
        return value;
    }

    @ServiceActivator(inputChannel="input.anonymous.errors")
    public void error(String value) {
        System.out.println("Handling ERROR payload: " + value);
    }

    public static interface PolledConsumer
    extends Processor {
        @Input
        public PollableMessageSource pollableSource();
    }
}

