/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.lang.reflect.Field;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.DefaultPollableMessageSource;
import org.springframework.cloud.stream.binder.JavaClassMimeTypeUtils;
import org.springframework.cloud.stream.binder.PartitionHandler;
import org.springframework.cloud.stream.binder.PollableMessageSource;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binding.MessageChannelAndSourceConfigurer;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.converter.MessageConverterUtils;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.expression.EvaluationContext;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.MutableMessageBuilderFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class MessageConverterConfigurer
implements MessageChannelAndSourceConfigurer,
BeanFactoryAware {
    private final MessageBuilderFactory messageBuilderFactory = new MutableMessageBuilderFactory();
    private final CompositeMessageConverter compositeMessageConverter;
    private final BindingServiceProperties bindingServiceProperties;
    private final Field headersField;
    private final StreamFunctionProperties streamFunctionProperties;
    private ConfigurableListableBeanFactory beanFactory;

    public MessageConverterConfigurer(BindingServiceProperties bindingServiceProperties, CompositeMessageConverter compositeMessageConverter, StreamFunctionProperties streamFunctionProperties) {
        Assert.notNull((Object)compositeMessageConverter, (String)"The message converter factory cannot be null");
        this.bindingServiceProperties = bindingServiceProperties;
        this.compositeMessageConverter = compositeMessageConverter;
        this.headersField = ReflectionUtils.findField(MessageHeaders.class, (String)"headers");
        this.headersField.setAccessible(true);
        this.streamFunctionProperties = streamFunctionProperties;
    }

    public MessageConverterConfigurer(BindingServiceProperties bindingServiceProperties, CompositeMessageConverter compositeMessageConverter) {
        this(bindingServiceProperties, compositeMessageConverter, null);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    @Override
    public void configureInputChannel(MessageChannel messageChannel, String channelName) {
        this.configureMessageChannel(messageChannel, channelName, true);
    }

    @Override
    public void configureOutputChannel(MessageChannel messageChannel, String channelName) {
        this.configureMessageChannel(messageChannel, channelName, false);
    }

    @Override
    public void configurePolledMessageSource(PollableMessageSource binding, String name) {
        BindingProperties bindingProperties = this.bindingServiceProperties.getBindingProperties(name);
        String contentType = bindingProperties.getContentType();
        ConsumerProperties consumerProperties = bindingProperties.getConsumer();
        if ((consumerProperties == null || !consumerProperties.isUseNativeDecoding()) && binding instanceof DefaultPollableMessageSource) {
            ((DefaultPollableMessageSource)binding).addInterceptor(new InboundContentTypeEnhancingInterceptor(contentType));
        }
    }

    private void configureMessageChannel(MessageChannel channel, String channelName, boolean inbound) {
        ConsumerProperties consumerProperties;
        boolean functional;
        Assert.isAssignable(AbstractMessageChannel.class, channel.getClass());
        AbstractMessageChannel messageChannel = (AbstractMessageChannel)channel;
        BindingProperties bindingProperties = this.bindingServiceProperties.getBindingProperties(channelName);
        String contentType = bindingProperties.getContentType();
        ProducerProperties producerProperties = bindingProperties.getProducer();
        boolean partitioned = !inbound && producerProperties != null && producerProperties.isPartitioned();
        boolean bl = functional = this.streamFunctionProperties != null && StringUtils.hasText((String)this.streamFunctionProperties.getDefinition());
        if (partitioned && (inbound || !functional)) {
            messageChannel.addInterceptor((ChannelInterceptor)new PartitioningInterceptor(bindingProperties));
        }
        if (this.isNativeEncodingNotSet(producerProperties, consumerProperties = bindingProperties.getConsumer(), inbound)) {
            if (inbound) {
                messageChannel.addInterceptor((ChannelInterceptor)new InboundContentTypeEnhancingInterceptor(contentType));
            } else {
                messageChannel.addInterceptor((ChannelInterceptor)new OutboundContentTypeConvertingInterceptor(contentType, this.compositeMessageConverter));
            }
        }
    }

    private boolean isNativeEncodingNotSet(ProducerProperties producerProperties, ConsumerProperties consumerProperties, boolean input) {
        if (input) {
            return consumerProperties == null || !consumerProperties.isUseNativeDecoding();
        }
        return producerProperties == null || !producerProperties.isUseNativeEncoding();
    }

    public final class PartitioningInterceptor
    implements ChannelInterceptor {
        private final BindingProperties bindingProperties;
        private final PartitionHandler partitionHandler;

        PartitioningInterceptor(BindingProperties bindingProperties) {
            this.bindingProperties = bindingProperties;
            this.partitionHandler = new PartitionHandler((EvaluationContext)ExpressionUtils.createStandardEvaluationContext((BeanFactory)MessageConverterConfigurer.this.beanFactory), this.bindingProperties.getProducer(), MessageConverterConfigurer.this.beanFactory);
        }

        public void setPartitionCount(int partitionCount) {
            this.partitionHandler.setPartitionCount(partitionCount);
        }

        public Message<?> preSend(Message<?> message, MessageChannel channel) {
            if (!message.getHeaders().containsKey((Object)"scst_partitionOverride")) {
                int partition = this.partitionHandler.determinePartition(message);
                return MessageConverterConfigurer.this.messageBuilderFactory.fromMessage(message).setHeader("scst_partition", (Object)partition).build();
            }
            return MessageConverterConfigurer.this.messageBuilderFactory.fromMessage(message).setHeader("scst_partition", message.getHeaders().get((Object)"scst_partitionOverride")).removeHeader("scst_partitionOverride").build();
        }
    }

    private abstract class AbstractContentTypeInterceptor
    implements ChannelInterceptor {
        final MimeType mimeType;

        private AbstractContentTypeInterceptor(String contentType) {
            this.mimeType = MessageConverterUtils.getMimeType(contentType);
        }

        public Message<?> preSend(Message<?> message, MessageChannel channel) {
            return message instanceof ErrorMessage ? message : this.doPreSend(message, channel);
        }

        protected abstract Message<?> doPreSend(Message<?> var1, MessageChannel var2);
    }

    private final class OutboundContentTypeConvertingInterceptor
    extends AbstractContentTypeInterceptor {
        private final MessageConverter messageConverter;

        private OutboundContentTypeConvertingInterceptor(String contentType, CompositeMessageConverter messageConverter) {
            super(contentType);
            this.messageConverter = messageConverter;
        }

        @Override
        public Message<?> doPreSend(Message<?> message, MessageChannel channel) {
            Message outboundMessage;
            String ct;
            if (message.getPayload() instanceof byte[] && message.getHeaders().containsKey((Object)"contentType")) {
                return message;
            }
            String oct = message.getHeaders().containsKey((Object)"contentType") ? message.getHeaders().get((Object)"contentType").toString() : null;
            String string = ct = message.getPayload() instanceof String ? JavaClassMimeTypeUtils.mimeTypeFromObject(message.getPayload(), ObjectUtils.nullSafeToString((Object)oct)).toString() : oct;
            if (!message.getHeaders().containsKey((Object)"contentType")) {
                Map headersMap = (Map)ReflectionUtils.getField((Field)MessageConverterConfigurer.this.headersField, (Object)message.getHeaders());
                headersMap.put("contentType", this.mimeType);
            }
            Message message2 = outboundMessage = message.getPayload() instanceof byte[] ? message : this.messageConverter.toMessage(message.getPayload(), message.getHeaders());
            if (outboundMessage == null) {
                throw new IllegalStateException("Failed to convert message: '" + message + "' to outbound message.");
            }
            if (ct != null && !ct.equals(oct) && oct != null) {
                Map headersMap = (Map)ReflectionUtils.getField((Field)MessageConverterConfigurer.this.headersField, (Object)outboundMessage.getHeaders());
                headersMap.put("contentType", MimeType.valueOf((String)ct));
            }
            return outboundMessage;
        }
    }

    private final class InboundContentTypeEnhancingInterceptor
    extends AbstractContentTypeInterceptor {
        private InboundContentTypeEnhancingInterceptor(String contentType) {
            super(contentType);
        }

        @Override
        public Message<?> doPreSend(Message<?> message, MessageChannel channel) {
            Map headersMap = (Map)ReflectionUtils.getField((Field)MessageConverterConfigurer.this.headersField, (Object)message.getHeaders());
            MimeType contentType = this.mimeType;
            if (!message.getHeaders().containsKey((Object)"contentType")) {
                headersMap.put("contentType", contentType);
            } else if (message.getHeaders().get((Object)"contentType") instanceof String) {
                headersMap.put("contentType", MimeType.valueOf((String)((String)message.getHeaders().get((Object)"contentType"))));
            }
            return message;
        }
    }
}

