/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.cloud.stream.binder.BinderConfiguration;
import org.springframework.cloud.stream.binder.DefaultBinderFactory;
import org.springframework.cloud.stream.config.BinderProperties;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.aot.ApplicationContextAotGenerator;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogAccessor;
import org.springframework.javapoet.ClassName;
import org.springframework.util.Assert;

public class BinderChildContextInitializer
implements ApplicationContextAware,
BeanRegistrationAotProcessor {
    private final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private DefaultBinderFactory binderFactory;
    private final Map<String, ApplicationContextInitializer<ConfigurableApplicationContext>> childContextInitializers;
    private volatile ConfigurableApplicationContext context;

    public BinderChildContextInitializer() {
        this.childContextInitializers = new HashMap<String, ApplicationContextInitializer<ConfigurableApplicationContext>>();
    }

    public BinderChildContextInitializer(Map<String, ApplicationContextInitializer<ConfigurableApplicationContext>> childContextInitializers) {
        this.childContextInitializers = childContextInitializers;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)applicationContext);
        this.context = (ConfigurableApplicationContext)applicationContext;
    }

    public void setBinderFactory(DefaultBinderFactory binderFactory) {
        Assert.notNull((Object)binderFactory, () -> "binderFactory must be non-null");
        this.binderFactory = binderFactory;
        if (!this.childContextInitializers.isEmpty()) {
            this.logger.info(() -> "Setting binder child context initializers on binder factory");
            this.binderFactory.setBinderChildContextInitializers(this.childContextInitializers);
        }
    }

    public boolean isBeanExcludedFromAotProcessing() {
        return false;
    }

    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        if (registeredBean.getBeanClass().equals(this.getClass())) {
            this.logger.info(() -> "Beginning AOT processing for binder child contexts");
            this.ensureBinderFactoryIsSet();
            BindingServiceProperties declaredBinders = this.declaredBindersAsBindingServiceProperties();
            Map<String, BinderConfiguration> binderConfigurations = BindingServiceConfiguration.getBinderConfigurations(this.binderFactory.getBinderTypeRegistry(), declaredBinders);
            this.binderFactory.updateBinderConfigurations(binderConfigurations);
            Map<String, ConfigurableApplicationContext> binderChildContexts = binderConfigurations.entrySet().stream().map(e -> Map.entry((String)e.getKey(), this.binderFactory.createBinderContextForAOT((String)e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return new BinderChildContextAotContribution(binderChildContexts);
        }
        return null;
    }

    private BindingServiceProperties declaredBindersAsBindingServiceProperties() {
        BindingServiceProperties bindingServiceProperties = new BindingServiceProperties();
        DeclaredBinders declaredBinders = new DeclaredBinders();
        Binder.get((Environment)this.context.getEnvironment()).bind(ConfigurationPropertyName.of((CharSequence)"spring.cloud.stream"), Bindable.ofInstance((Object)declaredBinders));
        bindingServiceProperties.setBinders(declaredBinders.getBinders());
        return bindingServiceProperties;
    }

    private void ensureBinderFactoryIsSet() {
        if (this.binderFactory == null) {
            Assert.notNull((Object)this.context, () -> "Unable to lookup binder factory from context as this.context is null");
            this.binderFactory = (DefaultBinderFactory)this.context.getBean(DefaultBinderFactory.class);
        }
    }

    public BinderChildContextInitializer withChildContextInitializers(Map<String, ApplicationContextInitializer<? extends ConfigurableApplicationContext>> childContextInitializers) {
        this.logger.info(() -> "Replacing instance w/ one that uses child context initializers");
        Map<String, ApplicationContextInitializer<ConfigurableApplicationContext>> downcastedInitializers = childContextInitializers.entrySet().stream().map(e -> Map.entry((String)e.getKey(), (ApplicationContextInitializer)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new BinderChildContextInitializer(downcastedInitializers);
    }

    private static class BinderChildContextAotContribution
    implements BeanRegistrationAotContribution {
        private final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
        private final Map<String, GenericApplicationContext> childContexts;

        BinderChildContextAotContribution(Map<String, ConfigurableApplicationContext> childContexts) {
            this.childContexts = childContexts.entrySet().stream().filter(e -> GenericApplicationContext.class.isInstance(e.getValue())).map(e -> Map.entry((String)e.getKey(), (GenericApplicationContext)GenericApplicationContext.class.cast(e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            ApplicationContextAotGenerator aotGenerator = new ApplicationContextAotGenerator();
            GeneratedMethod postProcessorMethod = beanRegistrationCode.getMethods().add("addChildContextInitializers", method -> {
                method.addJavadoc("Use AOT child context initialization", new Object[0]);
                method.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC});
                method.addParameter(RegisteredBean.class, "registeredBean", new Modifier[0]);
                method.addParameter(BinderChildContextInitializer.class, "instance", new Modifier[0]);
                method.returns(BinderChildContextInitializer.class);
                method.addStatement("$T<String, $T<? extends $T>> initializers = new $T<>()", new Object[]{Map.class, ApplicationContextInitializer.class, ConfigurableApplicationContext.class, HashMap.class});
                this.childContexts.forEach((name, context) -> {
                    this.logger.info(() -> "Generating AOT child context initializer for " + name);
                    GenerationContext childGenerationContext = generationContext.withName(name + "Binder");
                    ClassName initializerClassName = aotGenerator.processAheadOfTime(context, childGenerationContext);
                    method.addStatement("$T<? extends $T> " + name + "Initializer = new $L()", new Object[]{ApplicationContextInitializer.class, ConfigurableApplicationContext.class, initializerClassName});
                    method.addStatement("initializers.put($S," + name + "Initializer)", new Object[]{name});
                });
                method.addStatement("return instance.withChildContextInitializers(initializers)", new Object[0]);
            });
            beanRegistrationCode.addInstancePostProcessor(postProcessorMethod.toMethodReference());
        }
    }

    private static class DeclaredBinders {
        Map<String, BinderProperties> binders = new HashMap<String, BinderProperties>();

        private DeclaredBinders() {
        }

        public Map<String, BinderProperties> getBinders() {
            return this.binders;
        }

        public void setBinders(Map<String, BinderProperties> binders) {
            this.binders = binders;
        }
    }
}

