/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.binder.PartitionHandler;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.expression.EvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;

public class DefaultPartitioningInterceptor
implements ChannelInterceptor {
    private final PartitionHandler partitionHandler;

    public DefaultPartitioningInterceptor(BindingProperties bindingProperties, ConfigurableListableBeanFactory beanFactory) {
        this.partitionHandler = new PartitionHandler((EvaluationContext)ExpressionUtils.createStandardEvaluationContext((BeanFactory)beanFactory), bindingProperties.getProducer(), beanFactory);
    }

    public void setPartitionCount(int partitionCount) {
        this.partitionHandler.setPartitionCount(partitionCount);
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        if (!message.getHeaders().containsKey((Object)"scst_partitionOverride")) {
            int partition = this.partitionHandler.determinePartition(message);
            return ((MessageBuilder)MessageBuilder.fromMessage(message).setHeader("scst_partition", (Object)partition)).build();
        }
        return ((MessageBuilder)((MessageBuilder)MessageBuilder.fromMessage(message).setHeader("scst_partition", message.getHeaders().get((Object)"scst_partitionOverride"))).removeHeader("scst_partitionOverride")).build();
    }
}

