/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.listener;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.cloud.task.configuration.SimpleTaskAutoConfiguration;
import org.springframework.cloud.task.listener.TaskExecutionListener;
import org.springframework.cloud.task.listener.TaskLifecycleListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.integration.gateway.GatewayProxyFactoryBean;
import org.springframework.messaging.MessageChannel;

@Configuration
@ConditionalOnClass(value={EnableBinding.class})
@ConditionalOnBean(value={TaskLifecycleListener.class})
@ConditionalOnProperty(prefix="spring.cloud.task.events", name={"enabled"}, havingValue="true", matchIfMissing=true)
@PropertySource(value={"classpath:/org/springframework/cloud/task/application.properties"})
@AutoConfigureBefore(value={BindingServiceConfiguration.class})
@AutoConfigureAfter(value={SimpleTaskAutoConfiguration.class})
public class TaskEventAutoConfiguration {

    public static interface TaskEventChannels {
        public static final String TASK_EVENTS = "task-events";

        @Output(value="task-events")
        public MessageChannel taskEvents();
    }

    @Configuration
    @EnableBinding(value={TaskEventChannels.class})
    public static class ListenerConfiguration {
        @Bean
        public GatewayProxyFactoryBean taskEventListener() {
            GatewayProxyFactoryBean factoryBean = new GatewayProxyFactoryBean(TaskExecutionListener.class);
            factoryBean.setDefaultRequestChannelName("task-events");
            return factoryBean;
        }
    }
}

