/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.SkipListener;
import org.springframework.cloud.task.batch.listener.support.MessagePublisher;
import org.springframework.core.Ordered;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class EventEmittingSkipListener
implements SkipListener,
Ordered {
    private static final Log logger = LogFactory.getLog(EventEmittingSkipListener.class);
    private MessagePublisher<Object> messagePublisher;
    private int order = Integer.MAX_VALUE;

    public EventEmittingSkipListener(MessageChannel output) {
        Assert.notNull((Object)output, (String)"An output channel is required");
        this.messagePublisher = new MessagePublisher(output);
    }

    public EventEmittingSkipListener(MessageChannel output, int order) {
        this(output);
        this.order = order;
    }

    public void onSkipInRead(Throwable t) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing onSkipInRead: " + t.getMessage()), t);
        }
        this.messagePublisher.publishWithThrowableHeader("Skipped when reading.", t.getMessage());
    }

    public void onSkipInWrite(Object item, Throwable t) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing onSkipInWrite: " + t.getMessage()), t);
        }
        this.messagePublisher.publishWithThrowableHeader(item, t.getMessage());
    }

    public void onSkipInProcess(Object item, Throwable t) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing onSkipInProcess: " + t.getMessage()), t);
        }
        this.messagePublisher.publishWithThrowableHeader(item, t.getMessage());
    }

    public int getOrder() {
        return this.order;
    }
}

