/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.net.URI;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.commons.util.UtilAutoConfiguration;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.cloud.vault.config.VaultServerInstanceProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.client.VaultEndpointProvider;

@Configuration
@ConditionalOnProperty(value={"spring.cloud.vault.discovery.enabled"})
@EnableConfigurationProperties(value={VaultProperties.class})
@Order(value=0x7FFFFFFD)
@EnableDiscoveryClient
@Import(value={UtilAutoConfiguration.class})
public class DiscoveryClientVaultBootstrapConfiguration {
    private final VaultProperties vaultProperties;
    private final VaultServerInstanceProvider instanceProvider;

    public DiscoveryClientVaultBootstrapConfiguration(VaultProperties vaultProperties, DiscoveryClient discoveryClient) {
        this.vaultProperties = vaultProperties;
        this.instanceProvider = new VaultServerInstanceProvider(discoveryClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public VaultEndpointProvider vaultEndpointProvider() {
        String serviceId = this.vaultProperties.getDiscovery().getServiceId();
        String fallbackScheme = StringUtils.hasText((String)this.vaultProperties.getUri()) ? URI.create(this.vaultProperties.getUri()).getScheme() : this.vaultProperties.getScheme();
        ServiceInstance server = this.instanceProvider.getVaultServerInstance(serviceId);
        final VaultEndpoint vaultEndpoint = VaultEndpoint.create((String)server.getHost(), (int)server.getPort());
        if (server.getMetadata().containsKey("scheme")) {
            vaultEndpoint.setScheme((String)server.getMetadata().get("scheme"));
        } else {
            vaultEndpoint.setScheme(server.isSecure() ? "https" : fallbackScheme);
        }
        return new VaultEndpointProvider(){

            public VaultEndpoint getVaultEndpoint() {
                return vaultEndpoint;
            }
        };
    }
}

