/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.vault.config.VaultBootstrapConfiguration;
import org.springframework.cloud.vault.config.VaultHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.vault.core.VaultOperations;

@Configuration
@ConditionalOnClass(value={HealthIndicator.class})
@ConditionalOnBean(value={VaultBootstrapConfiguration.class})
@ConditionalOnProperty(name={"spring.cloud.vault.enabled"}, matchIfMissing=true)
@ConditionalOnExpression(value="${health.vault.enabled:true}")
@AutoConfigureBefore(value={EndpointAutoConfiguration.class})
@AutoConfigureAfter(value={HealthIndicatorAutoConfiguration.class})
public class VaultHealthIndicatorConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"vaultHealthIndicator"})
    public HealthIndicator vaultHealthIndicator(VaultOperations vaultOperations) {
        return new VaultHealthIndicator(vaultOperations);
    }
}

