/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.GcpCredentialSupplier;
import org.springframework.vault.authentication.GcpIamAuthentication;
import org.springframework.vault.authentication.GcpIamAuthenticationOptions;
import org.springframework.web.client.RestOperations;

final class GcpIamAuthenticationFactory {
    private GcpIamAuthenticationFactory() {
    }

    static ClientAuthentication create(VaultProperties vaultProperties, RestOperations restOperations) {
        VaultProperties.GcpIamProperties gcp = vaultProperties.getGcpIam();
        Assert.hasText((String)gcp.getRole(), (String)"Role (spring.cloud.vault.gcp-iam.role) must not be empty");
        GcpIamAuthenticationOptions.GcpIamAuthenticationOptionsBuilder builder = GcpIamAuthenticationOptions.builder().path(gcp.getGcpPath()).role(gcp.getRole()).jwtValidity(gcp.getJwtValidity());
        if (StringUtils.hasText((String)gcp.getProjectId())) {
            builder.projectId(gcp.getProjectId());
        }
        if (StringUtils.hasText((String)gcp.getServiceAccountId())) {
            builder.serviceAccountId(gcp.getServiceAccountId());
        }
        GcpCredentialSupplier supplier = () -> GcpIamAuthenticationFactory.getGoogleCredential(gcp);
        builder.credential(supplier.get());
        GcpIamAuthenticationOptions options = builder.build();
        return new GcpIamAuthentication(options, restOperations);
    }

    private static GoogleCredential getGoogleCredential(VaultProperties.GcpIamProperties gcp) throws IOException {
        VaultProperties.GcpCredentials credentialProperties = gcp.getCredentials();
        if (credentialProperties.getLocation() != null) {
            return GoogleCredential.fromStream((InputStream)credentialProperties.getLocation().getInputStream());
        }
        if (StringUtils.hasText((String)credentialProperties.getEncodedKey())) {
            return GoogleCredential.fromStream((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(credentialProperties.getEncodedKey())));
        }
        return GoogleCredential.getApplicationDefault();
    }
}

