/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.system.SystemProperties;
import org.springframework.cloud.vault.config.GcpIamAuthenticationFactory;
import org.springframework.cloud.vault.config.GcpIamCredentialsAuthenticationFactory;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.AppIdAuthentication;
import org.springframework.vault.authentication.AppIdAuthenticationOptions;
import org.springframework.vault.authentication.AppIdUserIdMechanism;
import org.springframework.vault.authentication.AppRoleAuthentication;
import org.springframework.vault.authentication.AppRoleAuthenticationOptions;
import org.springframework.vault.authentication.AwsEc2Authentication;
import org.springframework.vault.authentication.AwsEc2AuthenticationOptions;
import org.springframework.vault.authentication.AwsIamAuthentication;
import org.springframework.vault.authentication.AwsIamAuthenticationOptions;
import org.springframework.vault.authentication.AzureMsiAuthentication;
import org.springframework.vault.authentication.AzureMsiAuthenticationOptions;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.ClientCertificateAuthentication;
import org.springframework.vault.authentication.ClientCertificateAuthenticationOptions;
import org.springframework.vault.authentication.CubbyholeAuthentication;
import org.springframework.vault.authentication.CubbyholeAuthenticationOptions;
import org.springframework.vault.authentication.GcpComputeAuthentication;
import org.springframework.vault.authentication.GcpComputeAuthenticationOptions;
import org.springframework.vault.authentication.IpAddressUserId;
import org.springframework.vault.authentication.KubernetesAuthentication;
import org.springframework.vault.authentication.KubernetesAuthenticationOptions;
import org.springframework.vault.authentication.KubernetesServiceAccountTokenFile;
import org.springframework.vault.authentication.MacAddressUserId;
import org.springframework.vault.authentication.PcfAuthentication;
import org.springframework.vault.authentication.PcfAuthenticationOptions;
import org.springframework.vault.authentication.ResourceCredentialSupplier;
import org.springframework.vault.authentication.StaticUserId;
import org.springframework.vault.authentication.TokenAuthentication;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.RestOperations;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;

class ClientAuthenticationFactory {
    private static final boolean GOOGLE_CREDENTIAL_AVAILABLE = ClassUtils.isPresent((String)"com.google.api.client.googleapis.auth.oauth2.GoogleCredential", (ClassLoader)ClientAuthenticationFactory.class.getClassLoader());
    private static final boolean GOOGLE_CREDENTIALS_AVAILABLE = ClassUtils.isPresent((String)"com.google.auth.oauth2.GoogleCredentials", (ClassLoader)ClientAuthenticationFactory.class.getClassLoader());
    private final VaultProperties vaultProperties;
    private final RestOperations restOperations;
    private final RestOperations externalRestOperations;

    ClientAuthenticationFactory(VaultProperties vaultProperties, RestOperations restOperations, RestOperations externalRestOperations) {
        this.vaultProperties = vaultProperties;
        this.restOperations = restOperations;
        this.externalRestOperations = externalRestOperations;
    }

    ClientAuthentication createClientAuthentication() {
        switch (this.vaultProperties.getAuthentication()) {
            case APPID: {
                return this.appIdAuthentication(this.vaultProperties);
            }
            case APPROLE: {
                return this.appRoleAuthentication(this.vaultProperties);
            }
            case AWS_EC2: {
                return this.awsEc2Authentication(this.vaultProperties);
            }
            case AWS_IAM: {
                return this.awsIamAuthentication(this.vaultProperties);
            }
            case AZURE_MSI: {
                return this.azureMsiAuthentication(this.vaultProperties);
            }
            case CERT: {
                return this.certificateAuthentication(this.vaultProperties);
            }
            case CUBBYHOLE: {
                return this.cubbyholeAuthentication();
            }
            case GCP_GCE: {
                return this.gcpGceAuthentication(this.vaultProperties);
            }
            case GCP_IAM: {
                return this.gcpIamAuthentication(this.vaultProperties);
            }
            case KUBERNETES: {
                return this.kubernetesAuthentication(this.vaultProperties);
            }
            case PCF: {
                return this.pcfAuthentication(this.vaultProperties);
            }
            case TOKEN: {
                return this.tokenAuthentication(this.vaultProperties);
            }
        }
        throw new UnsupportedOperationException(String.format("Client authentication %s not supported", new Object[]{this.vaultProperties.getAuthentication()}));
    }

    private ClientAuthentication appIdAuthentication(VaultProperties vaultProperties) {
        VaultProperties.AppIdProperties appId = vaultProperties.getAppId();
        Assert.hasText((String)appId.getUserId(), (String)"UserId (spring.cloud.vault.app-id.user-id) must not be empty");
        AppIdAuthenticationOptions authenticationOptions = AppIdAuthenticationOptions.builder().appId(vaultProperties.getApplicationName()).path(appId.getAppIdPath()).userIdMechanism(this.getAppIdMechanism(appId)).build();
        return new AppIdAuthentication(authenticationOptions, this.restOperations);
    }

    private AppIdUserIdMechanism getAppIdMechanism(VaultProperties.AppIdProperties appId) {
        try {
            Class userIdClass = ClassUtils.forName((String)appId.getUserId(), null);
            return (AppIdUserIdMechanism)BeanUtils.instantiateClass((Class)userIdClass);
        }
        catch (ClassNotFoundException ex) {
            switch (appId.getUserId().toUpperCase()) {
                case "IP_ADDRESS": {
                    return new IpAddressUserId();
                }
                case "MAC_ADDRESS": {
                    if (StringUtils.hasText((String)appId.getNetworkInterface())) {
                        try {
                            return new MacAddressUserId(Integer.parseInt(appId.getNetworkInterface()));
                        }
                        catch (NumberFormatException e) {
                            return new MacAddressUserId(appId.getNetworkInterface());
                        }
                    }
                    return new MacAddressUserId();
                }
            }
            return new StaticUserId(appId.getUserId());
        }
    }

    private ClientAuthentication appRoleAuthentication(VaultProperties vaultProperties) {
        AppRoleAuthenticationOptions options = ClientAuthenticationFactory.getAppRoleAuthenticationOptions(vaultProperties);
        return new AppRoleAuthentication(options, this.restOperations);
    }

    static AppRoleAuthenticationOptions getAppRoleAuthenticationOptions(VaultProperties vaultProperties) {
        VaultProperties.AppRoleProperties appRole = vaultProperties.getAppRole();
        AppRoleAuthenticationOptions.AppRoleAuthenticationOptionsBuilder builder = AppRoleAuthenticationOptions.builder().path(appRole.getAppRolePath());
        if (StringUtils.hasText((String)appRole.getRole())) {
            builder.appRole(appRole.getRole());
        }
        AppRoleAuthenticationOptions.RoleId roleId = ClientAuthenticationFactory.getRoleId(vaultProperties, appRole);
        AppRoleAuthenticationOptions.SecretId secretId = ClientAuthenticationFactory.getSecretId(vaultProperties, appRole);
        builder.roleId(roleId).secretId(secretId);
        return builder.build();
    }

    private static AppRoleAuthenticationOptions.RoleId getRoleId(VaultProperties vaultProperties, VaultProperties.AppRoleProperties appRole) {
        if (StringUtils.hasText((String)appRole.getRoleId())) {
            return AppRoleAuthenticationOptions.RoleId.provided((String)appRole.getRoleId());
        }
        if (StringUtils.hasText((String)vaultProperties.getToken()) && StringUtils.hasText((String)appRole.getRole())) {
            return AppRoleAuthenticationOptions.RoleId.pull((VaultToken)VaultToken.of((String)vaultProperties.getToken()));
        }
        if (StringUtils.hasText((String)vaultProperties.getToken())) {
            return AppRoleAuthenticationOptions.RoleId.wrapped((VaultToken)VaultToken.of((String)vaultProperties.getToken()));
        }
        throw new IllegalArgumentException("Cannot configure RoleId. Any of role-id, initial token, or initial token and role name must be configured.");
    }

    private static AppRoleAuthenticationOptions.SecretId getSecretId(VaultProperties vaultProperties, VaultProperties.AppRoleProperties appRole) {
        if (StringUtils.hasText((String)appRole.getSecretId())) {
            return AppRoleAuthenticationOptions.SecretId.provided((String)appRole.getSecretId());
        }
        if (StringUtils.hasText((String)vaultProperties.getToken()) && StringUtils.hasText((String)appRole.getRole())) {
            return AppRoleAuthenticationOptions.SecretId.pull((VaultToken)VaultToken.of((String)vaultProperties.getToken()));
        }
        if (StringUtils.hasText((String)vaultProperties.getToken())) {
            return AppRoleAuthenticationOptions.SecretId.wrapped((VaultToken)VaultToken.of((String)vaultProperties.getToken()));
        }
        return AppRoleAuthenticationOptions.SecretId.absent();
    }

    private ClientAuthentication awsEc2Authentication(VaultProperties vaultProperties) {
        VaultProperties.AwsEc2Properties awsEc2 = vaultProperties.getAwsEc2();
        AwsEc2AuthenticationOptions.Nonce nonce = StringUtils.hasText((String)awsEc2.getNonce()) ? AwsEc2AuthenticationOptions.Nonce.provided((char[])awsEc2.getNonce().toCharArray()) : AwsEc2AuthenticationOptions.Nonce.generated();
        AwsEc2AuthenticationOptions authenticationOptions = AwsEc2AuthenticationOptions.builder().role(awsEc2.getRole()).path(awsEc2.getAwsEc2Path()).nonce(nonce).identityDocumentUri(awsEc2.getIdentityDocument()).build();
        return new AwsEc2Authentication(authenticationOptions, this.restOperations, this.externalRestOperations);
    }

    private ClientAuthentication awsIamAuthentication(VaultProperties vaultProperties) {
        VaultProperties.AwsIamProperties awsIam = vaultProperties.getAwsIam();
        AwsCredentialsProvider credentialsProvider = AwsCredentialProvider.getAwsCredentialsProvider();
        AwsIamAuthenticationOptions.AwsIamAuthenticationOptionsBuilder builder = AwsIamAuthenticationOptions.builder();
        if (StringUtils.hasText((String)awsIam.getRole())) {
            builder.role(awsIam.getRole());
        }
        if (StringUtils.hasText((String)awsIam.getServerName())) {
            builder.serverName(awsIam.getServerName());
        }
        if (awsIam.getEndpointUri() != null) {
            builder.endpointUri(awsIam.getEndpointUri());
        }
        builder.path(awsIam.getAwsPath()).credentialsProvider(credentialsProvider);
        AwsIamAuthenticationOptions options = builder.credentialsProvider(credentialsProvider).build();
        return new AwsIamAuthentication(options, this.restOperations);
    }

    private ClientAuthentication azureMsiAuthentication(VaultProperties vaultProperties) {
        VaultProperties.AzureMsiProperties azureMsi = vaultProperties.getAzureMsi();
        Assert.hasText((String)azureMsi.getRole(), (String)"Azure role (spring.cloud.vault.azure-msi.role) must not be empty");
        AzureMsiAuthenticationOptions options = AzureMsiAuthenticationOptions.builder().role(azureMsi.getRole()).path(azureMsi.getAzurePath()).instanceMetadataUri(azureMsi.getMetadataService()).identityTokenServiceUri(azureMsi.getIdentityTokenService()).build();
        return new AzureMsiAuthentication(options, this.restOperations, this.externalRestOperations);
    }

    private ClientAuthentication cubbyholeAuthentication() {
        Assert.hasText((String)this.vaultProperties.getToken(), (String)"Initial Token (spring.cloud.vault.token) for Cubbyhole authentication must not be empty");
        CubbyholeAuthenticationOptions options = CubbyholeAuthenticationOptions.builder().wrapped().initialToken(VaultToken.of((String)this.vaultProperties.getToken())).build();
        return new CubbyholeAuthentication(options, this.restOperations);
    }

    private ClientAuthentication gcpGceAuthentication(VaultProperties vaultProperties) {
        VaultProperties.GcpGceProperties gcp = vaultProperties.getGcpGce();
        Assert.hasText((String)gcp.getRole(), (String)"Role (spring.cloud.vault.gcp-gce.role) must not be empty");
        GcpComputeAuthenticationOptions.GcpComputeAuthenticationOptionsBuilder builder = GcpComputeAuthenticationOptions.builder().path(gcp.getGcpPath()).role(gcp.getRole());
        if (StringUtils.hasText((String)gcp.getServiceAccount())) {
            builder.serviceAccount(gcp.getServiceAccount());
        }
        return new GcpComputeAuthentication(builder.build(), this.restOperations, this.externalRestOperations);
    }

    private ClientAuthentication gcpIamAuthentication(VaultProperties vaultProperties) {
        if (GOOGLE_CREDENTIAL_AVAILABLE) {
            return GcpIamAuthenticationFactory.create(vaultProperties, this.restOperations);
        }
        if (GOOGLE_CREDENTIALS_AVAILABLE) {
            return GcpIamCredentialsAuthenticationFactory.create(vaultProperties, this.restOperations);
        }
        throw new IllegalStateException("Cannot create authentication mechanism for GCP IAM. This method requires one of the following dependencies: google-auth-library-oauth2-http or google-api-client (deprecated).");
    }

    private ClientAuthentication kubernetesAuthentication(VaultProperties vaultProperties) {
        VaultProperties.KubernetesProperties kubernetes = vaultProperties.getKubernetes();
        Assert.hasText((String)kubernetes.getRole(), (String)"Role (spring.cloud.vault.kubernetes.role) must not be empty");
        Assert.hasText((String)kubernetes.getServiceAccountTokenFile(), (String)"Service account token file (spring.cloud.vault.kubernetes.service-account-token-file) must not be empty");
        KubernetesAuthenticationOptions options = KubernetesAuthenticationOptions.builder().path(kubernetes.getKubernetesPath()).role(kubernetes.getRole()).jwtSupplier((Supplier)new KubernetesServiceAccountTokenFile(kubernetes.getServiceAccountTokenFile())).build();
        return new KubernetesAuthentication(options, this.restOperations);
    }

    private ClientAuthentication pcfAuthentication(VaultProperties vaultProperties) {
        VaultProperties.PcfProperties pcfProperties = vaultProperties.getPcf();
        Assert.isTrue((boolean)ClassUtils.isPresent((String)"org.bouncycastle.crypto.signers.PSSSigner", (ClassLoader)this.getClass().getClassLoader()), (String)"BouncyCastle (bcpkix-jdk15on) must be on the classpath");
        Assert.hasText((String)pcfProperties.getRole(), (String)"Role (spring.cloud.vault.pcf.role) must not be empty");
        PcfAuthenticationOptions.PcfAuthenticationOptionsBuilder builder = PcfAuthenticationOptions.builder().role(pcfProperties.getRole()).path(pcfProperties.getPcfPath());
        if (pcfProperties.getInstanceCertificate() != null) {
            builder.instanceCertificate((Supplier)new ResourceCredentialSupplier(pcfProperties.getInstanceCertificate()));
        }
        if (pcfProperties.getInstanceKey() != null) {
            builder.instanceKey((Supplier)new ResourceCredentialSupplier(pcfProperties.getInstanceKey()));
        }
        return new PcfAuthentication(builder.build(), this.restOperations);
    }

    private ClientAuthentication certificateAuthentication(VaultProperties vaultProperties) {
        ClientCertificateAuthenticationOptions options = ClientCertificateAuthenticationOptions.builder().path(vaultProperties.getSsl().getCertAuthPath()).build();
        return new ClientCertificateAuthentication(options, this.restOperations);
    }

    private ClientAuthentication tokenAuthentication(VaultProperties vaultProperties) {
        if (StringUtils.hasText((String)vaultProperties.getToken())) {
            return new TokenAuthentication(vaultProperties.getToken());
        }
        Path vaultTokenPath = Paths.get(SystemProperties.get((String[])new String[]{"user.home"}), ".vault-token");
        if (Files.exists(vaultTokenPath, new LinkOption[0])) {
            try {
                return new TokenAuthentication(new String(Files.readAllBytes(vaultTokenPath), StandardCharsets.UTF_8));
            }
            catch (IOException ex) {
                throw new IllegalStateException(String.format("Could not retrieve vault token from %s", vaultTokenPath), ex);
            }
        }
        throw new IllegalStateException("Cannot create authentication mechanism for TOKEN. This method requires either a Token (spring.cloud.vault.token) or a token file at ~/.vault-token.");
    }

    private static class AwsCredentialProvider {
        private AwsCredentialProvider() {
        }

        private static AwsCredentialsProvider getAwsCredentialsProvider() {
            final DefaultCredentialsProvider backingCredentialsProvider = DefaultCredentialsProvider.create();
            final AwsCredentials firstAccess = backingCredentialsProvider.resolveCredentials();
            final AtomicReference<AwsCredentials> once = new AtomicReference<AwsCredentials>(firstAccess);
            return new AwsCredentialsProvider(){

                public AwsCredentials resolveCredentials() {
                    if (once.compareAndSet(firstAccess, null)) {
                        return firstAccess;
                    }
                    return backingCredentialsProvider.resolveCredentials();
                }
            };
        }
    }
}

