/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.springframework.boot.actuate.health.Health;
import org.springframework.cloud.client.discovery.health.DiscoveryHealthIndicator;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServiceDiscovery;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServiceInstances;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;

public class ZookeeperDiscoveryHealthIndicator
implements DiscoveryHealthIndicator {
    private static final Log log = LogFactory.getLog(ZookeeperDiscoveryHealthIndicator.class);
    private ZookeeperServiceDiscovery zookeeperServiceDiscovery;
    private CuratorFramework curatorFramework;
    private ServiceDiscovery<ZookeeperInstance> serviceDiscovery;
    private final ZookeeperDependencies zookeeperDependencies;
    private final ZookeeperDiscoveryProperties zookeeperDiscoveryProperties;

    @Deprecated
    public ZookeeperDiscoveryHealthIndicator(ZookeeperServiceDiscovery zookeeperServiceDiscovery, ZookeeperDependencies zookeeperDependencies, ZookeeperDiscoveryProperties zookeeperDiscoveryProperties) {
        this.zookeeperServiceDiscovery = zookeeperServiceDiscovery;
        this.zookeeperDependencies = zookeeperDependencies;
        this.zookeeperDiscoveryProperties = zookeeperDiscoveryProperties;
    }

    public ZookeeperDiscoveryHealthIndicator(CuratorFramework curatorFramework, ServiceDiscovery<ZookeeperInstance> serviceDiscovery, ZookeeperDependencies zookeeperDependencies, ZookeeperDiscoveryProperties zookeeperDiscoveryProperties) {
        this.curatorFramework = curatorFramework;
        this.serviceDiscovery = serviceDiscovery;
        this.zookeeperDependencies = zookeeperDependencies;
        this.zookeeperDiscoveryProperties = zookeeperDiscoveryProperties;
    }

    public String getName() {
        return "zookeeper";
    }

    public Health health() {
        Health.Builder builder = Health.unknown();
        try {
            ZookeeperServiceInstances allInstances = this.zookeeperServiceDiscovery != null ? new ZookeeperServiceInstances(this.zookeeperServiceDiscovery, this.zookeeperDependencies, this.zookeeperDiscoveryProperties) : new ZookeeperServiceInstances(this.curatorFramework, this.serviceDiscovery, this.zookeeperDependencies, this.zookeeperDiscoveryProperties);
            builder.up().withDetail("services", (Object)allInstances);
        }
        catch (Exception e) {
            log.error((Object)"Error", (Throwable)e);
            builder.down(e);
        }
        return builder.build();
    }
}

