/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.credhub.autoconfig;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.credhub.configuration.CredHubTemplateFactory;
import org.springframework.credhub.core.CredHubProperties;
import org.springframework.credhub.core.ReactiveCredHubOperations;
import org.springframework.credhub.support.ClientOptions;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;

@Import(value={ReactiveCredHubTemplateBaseConfiguration.class, ReactiveCredHubTemplateOAuth2Configuration.class, ReactiveCredHubTemplateOAuth2ClientConfiguration.class})
public class ReactiveCredHubTemplateConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
    @ConditionalOnProperty(prefix="spring.credhub.oauth2", name={"registration-id"})
    @ConditionalOnBean(value={ReactiveOAuth2AuthorizedClientManager.class})
    static class ReactiveCredHubTemplateOAuth2ClientConfiguration {
        ReactiveCredHubTemplateOAuth2ClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ReactiveCredHubOperations reactiveCredHubTemplate(CredHubProperties credHubProperties, ClientOptions clientOptions, ReactiveOAuth2AuthorizedClientManager clientManager) {
            return new CredHubTemplateFactory().reactiveCredHubTemplate(credHubProperties, clientOptions, clientManager);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
    @ConditionalOnProperty(prefix="spring.credhub.oauth2", name={"registration-id"})
    @ConditionalOnMissingBean(value={ReactiveOAuth2AuthorizedClientManager.class})
    static class ReactiveCredHubTemplateOAuth2Configuration {
        ReactiveCredHubTemplateOAuth2Configuration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ReactiveCredHubOperations reactiveCredHubTemplate(CredHubProperties credHubProperties, ClientOptions clientOptions, ReactiveClientRegistrationRepository clientRegistrationRepository, ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
            return new CredHubTemplateFactory().reactiveCredHubTemplate(credHubProperties, clientOptions, clientRegistrationRepository, authorizedClientRepository);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
    @ConditionalOnProperty(prefix="spring.credhub.oauth2", name={"registration-id"}, havingValue="false", matchIfMissing=true)
    static class ReactiveCredHubTemplateBaseConfiguration {
        ReactiveCredHubTemplateBaseConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ReactiveCredHubOperations reactiveCredHubTemplate(CredHubProperties credHubProperties, ClientOptions clientOptions) {
            return new CredHubTemplateFactory().reactiveCredHubTemplate(credHubProperties, clientOptions);
        }
    }
}

