/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.credhub.autoconfig;

import java.util.ArrayList;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.client.ClientsConfiguredCondition;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientPropertiesRegistrationAdapter;
import org.springframework.boot.autoconfigure.security.oauth2.client.reactive.ReactiveOAuth2ClientAutoConfiguration;
import org.springframework.boot.autoconfigure.security.oauth2.client.servlet.OAuth2ClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.security.oauth2.client.AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.InMemoryReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;

@AutoConfiguration(after={OAuth2ClientAutoConfiguration.class, ReactiveOAuth2ClientAutoConfiguration.class})
@EnableConfigurationProperties(value={OAuth2ClientProperties.class})
@ConditionalOnClass(name={"org.springframework.security.oauth2.client.registration.ClientRegistration"})
@ConditionalOnProperty(value={"spring.credhub.oauth2.registration-id"})
@Conditional(value={ClientsConfiguredCondition.class})
public class CredHubOAuth2AutoConfiguration {
    private final OAuth2ClientProperties properties;

    CredHubOAuth2AutoConfiguration(OAuth2ClientProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"javax.servlet.http.HttpServletRequest"})
    public ClientRegistrationRepository credHubClientRegistrationRepository() {
        ArrayList registrations = new ArrayList(OAuth2ClientPropertiesRegistrationAdapter.getClientRegistrations((OAuth2ClientProperties)this.properties).values());
        return new InMemoryClientRegistrationRepository(registrations);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"javax.servlet.http.HttpServletRequest"})
    public OAuth2AuthorizedClientRepository credHubAuthorizedClientRepository(ClientRegistrationRepository clientRegistrationRepository) {
        return new AuthenticatedPrincipalOAuth2AuthorizedClientRepository((OAuth2AuthorizedClientService)new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository));
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
    public ReactiveClientRegistrationRepository credHubReactiveClientRegistrationRepository() {
        ArrayList registrations = new ArrayList(OAuth2ClientPropertiesRegistrationAdapter.getClientRegistrations((OAuth2ClientProperties)this.properties).values());
        return new InMemoryReactiveClientRegistrationRepository(registrations);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
    public ReactiveOAuth2AuthorizedClientManager credHubReactiveAuthorizedClientManager(ReactiveClientRegistrationRepository clientRegistrationRepository, ReactiveOAuth2AuthorizedClientService authorizedClientService) {
        return new AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientService);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
    public ReactiveOAuth2AuthorizedClientService credHubReactiveAuthorizedClientService(ReactiveClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryReactiveOAuth2AuthorizedClientService(clientRegistrationRepository);
    }
}

