/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.credhub.autoconfig;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.credhub.configuration.CredHubTemplateFactory;
import org.springframework.credhub.core.CredHubOperations;
import org.springframework.credhub.core.CredHubProperties;
import org.springframework.credhub.support.ClientOptions;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;

@Import(value={CredHubTemplateBaseConfiguration.class, CredHubTemplateOAuth2Configuration.class, CredHubTemplateOAuth2ClientConfiguration.class})
public class CredHubTemplateConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"javax.servlet.http.HttpServletRequest"})
    @ConditionalOnProperty(prefix="spring.credhub.oauth2", name={"registration-id"})
    @ConditionalOnBean(value={OAuth2AuthorizedClientManager.class})
    static class CredHubTemplateOAuth2ClientConfiguration {
        CredHubTemplateOAuth2ClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        CredHubOperations credHubTemplate(CredHubProperties credHubProperties, ClientOptions clientOptions, ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientManager clientManager) {
            return new CredHubTemplateFactory().credHubTemplate(credHubProperties, clientOptions, clientRegistrationRepository, clientManager);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"javax.servlet.http.HttpServletRequest"})
    @ConditionalOnProperty(prefix="spring.credhub.oauth2", name={"registration-id"})
    @ConditionalOnMissingBean(value={OAuth2AuthorizedClientManager.class})
    static class CredHubTemplateOAuth2Configuration {
        CredHubTemplateOAuth2Configuration() {
        }

        @Bean
        @ConditionalOnMissingBean
        CredHubOperations credHubTemplate(CredHubProperties credHubProperties, ClientOptions clientOptions, ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientRepository authorizedClientRepository) {
            return new CredHubTemplateFactory().credHubTemplate(credHubProperties, clientOptions, clientRegistrationRepository, authorizedClientRepository);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"javax.servlet.http.HttpServletRequest"})
    @ConditionalOnProperty(prefix="spring.credhub.oauth2", name={"registration-id"}, havingValue="false", matchIfMissing=true)
    static class CredHubTemplateBaseConfiguration {
        CredHubTemplateBaseConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        CredHubOperations credHubTemplate(CredHubProperties credHubProperties, ClientOptions clientOptions) {
            return new CredHubTemplateFactory().credHubTemplate(credHubProperties, clientOptions);
        }
    }
}

