/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.credhub.diagnostics;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;

class ClientNotConfiguredFailureAnalyzer
extends AbstractFailureAnalyzer<NoSuchBeanDefinitionException> {
    private final BeanFactory beanFactory;

    ClientNotConfiguredFailureAnalyzer(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected FailureAnalysis analyze(Throwable rootFailure, NoSuchBeanDefinitionException cause) {
        if (this.hasCredHubProperties() && this.isMissingSpringSecurityOAuth2Bean(cause.getBeanType())) {
            return new FailureAnalysis(this.getDescription(), this.getAction(), (Throwable)cause);
        }
        return null;
    }

    private boolean hasCredHubProperties() {
        return this.beanFactory.containsBean("credHubProperties");
    }

    private boolean isMissingSpringSecurityOAuth2Bean(Class<?> notFoundBean) {
        return notFoundBean != null && (notFoundBean.getName().contains("ClientRegistrationRepository") || notFoundBean.getName().contains("OAuth2AuthorizedClientRepository"));
    }

    private String getDescription() {
        return "A CredHub OAuth2 client registration is configured but Spring Security is not available or the Spring Security OAuth2 client registration not configured correctly.";
    }

    private String getAction() {
        return "Add Spring Security to the application classpath and configure properties for the OAuth2 client registration under 'spring.security.oauth2.client.registration'.";
    }
}

