/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.config;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.LatencyTracker;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cassandra.config.CompressionType;
import org.springframework.cassandra.core.CqlTemplate;
import org.springframework.cassandra.core.cql.generator.CreateKeyspaceCqlGenerator;
import org.springframework.cassandra.core.cql.generator.DropKeyspaceCqlGenerator;
import org.springframework.cassandra.core.keyspace.CreateKeyspaceSpecification;
import org.springframework.cassandra.core.keyspace.DropKeyspaceSpecification;
import org.springframework.cassandra.core.keyspace.KeyspaceActionSpecification;
import org.springframework.cassandra.support.CassandraExceptionTranslator;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.util.StringUtils;

public class CassandraCqlClusterFactoryBean
implements FactoryBean<Cluster>,
InitializingBean,
DisposableBean,
PersistenceExceptionTranslator {
    public static final String DEFAULT_CONTACT_POINTS = "localhost";
    public static final boolean DEFAULT_METRICS_ENABLED = true;
    public static final boolean DEFAULT_DEFERRED_INITIALIZATION = false;
    public static final boolean DEFAULT_JMX_REPORTING_ENABLED = true;
    public static final boolean DEFAULT_SSL_ENABLED = false;
    public static final int DEFAULT_PORT = 9042;
    protected static final Logger log = LoggerFactory.getLogger(CassandraCqlClusterFactoryBean.class);
    private Cluster cluster;
    private String contactPoints = "localhost";
    private int port = 9042;
    private CompressionType compressionType;
    private PoolingOptions poolingOptions;
    private SocketOptions socketOptions;
    private AuthProvider authProvider;
    private String username;
    private String password;
    private LoadBalancingPolicy loadBalancingPolicy;
    private ReconnectionPolicy reconnectionPolicy;
    private RetryPolicy retryPolicy;
    private boolean metricsEnabled = true;
    private boolean jmxReportingEnabled = true;
    private boolean sslEnabled = false;
    private SSLOptions sslOptions;
    private Host.StateListener hostStateListener;
    private LatencyTracker latencyTracker;
    private Set<KeyspaceActionSpecification<?>> keyspaceSpecifications = new HashSet();
    private List<CreateKeyspaceSpecification> keyspaceCreations = new ArrayList<CreateKeyspaceSpecification>();
    private List<DropKeyspaceSpecification> keyspaceDrops = new ArrayList<DropKeyspaceSpecification>();
    private List<String> startupScripts = new ArrayList<String>();
    private List<String> shutdownScripts = new ArrayList<String>();
    private final PersistenceExceptionTranslator exceptionTranslator = new CassandraExceptionTranslator();

    public Cluster getObject() throws Exception {
        return this.cluster;
    }

    public Class<? extends Cluster> getObjectType() {
        return Cluster.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.exceptionTranslator.translateExceptionIfPossible(ex);
    }

    public void afterPropertiesSet() throws Exception {
        if (!StringUtils.hasText((String)this.contactPoints)) {
            throw new IllegalArgumentException("at least one server is required");
        }
        Cluster.Builder builder = Cluster.builder();
        builder.addContactPoints(StringUtils.commaDelimitedListToStringArray((String)this.contactPoints)).withPort(this.port);
        if (this.compressionType != null) {
            builder.withCompression(CassandraCqlClusterFactoryBean.convertCompressionType(this.compressionType));
        }
        if (this.poolingOptions != null) {
            builder.withPoolingOptions(this.poolingOptions);
        }
        if (this.socketOptions != null) {
            builder.withSocketOptions(this.socketOptions);
        }
        if (this.authProvider != null) {
            builder.withAuthProvider(this.authProvider);
            if (this.username != null) {
                builder.withCredentials(this.username, this.password);
            }
        }
        if (this.loadBalancingPolicy != null) {
            builder.withLoadBalancingPolicy(this.loadBalancingPolicy);
        }
        if (this.reconnectionPolicy != null) {
            builder.withReconnectionPolicy(this.reconnectionPolicy);
        }
        if (this.retryPolicy != null) {
            builder.withRetryPolicy(this.retryPolicy);
        }
        if (!this.metricsEnabled) {
            builder.withoutMetrics();
        }
        if (!this.jmxReportingEnabled) {
            builder.withoutJMXReporting();
        }
        if (this.sslEnabled) {
            if (this.sslOptions == null) {
                builder.withSSL();
            } else {
                builder.withSSL(this.sslOptions);
            }
        }
        this.cluster = builder.build();
        if (this.hostStateListener != null) {
            this.cluster.register(this.hostStateListener);
        }
        if (this.latencyTracker != null) {
            this.cluster.register(this.latencyTracker);
        }
        this.generateSpecificationsFromFactoryBeans();
        this.executeSpecsAndScripts(this.keyspaceCreations, this.startupScripts);
    }

    private void generateSpecificationsFromFactoryBeans() {
        for (KeyspaceActionSpecification<?> spec : this.keyspaceSpecifications) {
            if (spec instanceof CreateKeyspaceSpecification) {
                this.keyspaceCreations.add((CreateKeyspaceSpecification)spec);
            }
            if (!(spec instanceof DropKeyspaceSpecification)) continue;
            this.keyspaceDrops.add((DropKeyspaceSpecification)spec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSpecsAndScripts(List specs, List<String> scripts) {
        Session system = null;
        CqlTemplate template = null;
        try {
            if (specs != null) {
                system = specs.size() == 0 ? null : this.cluster.connect();
                template = system == null ? null : new CqlTemplate(system);
                for (KeyspaceActionSpecification spec : specs) {
                    String cql = spec instanceof CreateKeyspaceSpecification ? new CreateKeyspaceCqlGenerator((CreateKeyspaceSpecification)spec).toCql() : new DropKeyspaceCqlGenerator((DropKeyspaceSpecification)spec).toCql();
                    template.execute(cql);
                }
            }
            if (scripts != null) {
                if (system == null) {
                    Session session = system = scripts.size() == 0 ? null : this.cluster.connect();
                }
                if (template == null) {
                    template = system == null ? null : new CqlTemplate(system);
                }
                for (String script : scripts) {
                    if (log.isDebugEnabled()) {
                        log.debug("executing raw CQL [{}]", (Object)script);
                    }
                    template.execute(script);
                }
            }
        }
        finally {
            if (system != null) {
                system.close();
            }
        }
    }

    public void destroy() throws Exception {
        this.executeSpecsAndScripts(this.keyspaceDrops, this.shutdownScripts);
        this.cluster.close();
    }

    public void setContactPoints(String contactPoints) {
        this.contactPoints = contactPoints;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public void setPoolingOptions(PoolingOptions poolingOptions) {
        this.poolingOptions = poolingOptions;
    }

    public void setSocketOptions(SocketOptions socketOptions) {
        this.socketOptions = socketOptions;
    }

    public void setAuthProvider(AuthProvider authProvider) {
        this.authProvider = authProvider;
    }

    public void setLoadBalancingPolicy(LoadBalancingPolicy loadBalancingPolicy) {
        this.loadBalancingPolicy = loadBalancingPolicy;
    }

    public void setReconnectionPolicy(ReconnectionPolicy reconnectionPolicy) {
        this.reconnectionPolicy = reconnectionPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public void setMetricsEnabled(boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
    }

    public void setKeyspaceCreations(List<CreateKeyspaceSpecification> specifications) {
        this.keyspaceCreations = specifications;
    }

    public List<CreateKeyspaceSpecification> getKeyspaceCreations() {
        return this.keyspaceCreations;
    }

    public void setKeyspaceDrops(List<DropKeyspaceSpecification> specifications) {
        this.keyspaceDrops = specifications;
    }

    public List<DropKeyspaceSpecification> getKeyspaceDrops() {
        return this.keyspaceDrops;
    }

    public void setStartupScripts(List<String> scripts) {
        this.startupScripts = scripts;
    }

    public void setShutdownScripts(List<String> scripts) {
        this.shutdownScripts = scripts;
    }

    private static ProtocolOptions.Compression convertCompressionType(CompressionType type) {
        switch (type) {
            case NONE: {
                return ProtocolOptions.Compression.NONE;
            }
            case SNAPPY: {
                return ProtocolOptions.Compression.SNAPPY;
            }
        }
        throw new IllegalArgumentException("unknown compression type " + (Object)((Object)type));
    }

    public Set<KeyspaceActionSpecification<?>> getKeyspaceSpecifications() {
        return this.keyspaceSpecifications;
    }

    public void setKeyspaceSpecifications(Set<KeyspaceActionSpecification<?>> keyspaceSpecifications) {
        this.keyspaceSpecifications = keyspaceSpecifications;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setJmxReportingEnabled(boolean jmxReportingEnabled) {
        this.jmxReportingEnabled = jmxReportingEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public void setSslOptions(SSLOptions sslOptions) {
        this.sslOptions = sslOptions;
    }

    public void setHostStateListener(Host.StateListener hostStateListener) {
        this.hostStateListener = hostStateListener;
    }

    public void setLatencyTracker(LatencyTracker latencyTracker) {
        this.latencyTracker = latencyTracker;
    }
}

