/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.config.xml;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ParsingUtils {
    public static void addOptionalPropertyValue(BeanDefinitionBuilder builder, String propertyName, Element element, String attrName, String defaultValue) {
        ParsingUtils.addProperty(builder, propertyName, element.getAttribute(attrName), defaultValue, false, false);
    }

    public static void addOptionalPropertyReference(BeanDefinitionBuilder builder, String propertyName, Element element, String attrName, String defaultValue) {
        ParsingUtils.addProperty(builder, propertyName, element.getAttribute(attrName), defaultValue, false, true);
    }

    public static void addRequiredPropertyValue(BeanDefinitionBuilder builder, String propertyName, Element element, String attrName) {
        ParsingUtils.addProperty(builder, propertyName, element.getAttribute(attrName), null, true, false);
    }

    public static void addRequiredPropertyReference(BeanDefinitionBuilder builder, String propertyName, Element element, String attrName) {
        ParsingUtils.addProperty(builder, propertyName, element.getAttribute(attrName), null, true, true);
    }

    public static void addPropertyValue(BeanDefinitionBuilder builder, String propertyName, Element element, String attrName, String defaultValue, boolean required) {
        ParsingUtils.addProperty(builder, propertyName, element.getAttribute(attrName), defaultValue, required, false);
    }

    public static void addPropertyReference(BeanDefinitionBuilder builder, String propertyName, Element element, String attrName, String defaultValue, boolean required) {
        ParsingUtils.addProperty(builder, propertyName, element.getAttribute(attrName), defaultValue, required, true);
    }

    public static void addProperty(BeanDefinitionBuilder builder, String propertyName, Element element, String attrName, String defaultValue, boolean required, boolean reference) {
        Assert.notNull((Object)element, (String)"Element must not be null!");
        Assert.hasText((String)attrName, (String)"Attribute name must not be null!");
        ParsingUtils.addProperty(builder, propertyName, element.getAttribute(attrName), defaultValue, required, reference);
    }

    public static void addOptionalPropertyValue(BeanDefinitionBuilder builder, String propertyName, Attr attr, String defaultValue) {
        ParsingUtils.addProperty(builder, propertyName, attr, defaultValue, false, false);
    }

    public static void addOptionalPropertyReference(BeanDefinitionBuilder builder, String propertyName, Attr attr, String defaultValue) {
        ParsingUtils.addProperty(builder, propertyName, attr, defaultValue, false, true);
    }

    public static void addRequiredPropertyValue(BeanDefinitionBuilder builder, String propertyName, Attr attr) {
        ParsingUtils.addProperty(builder, propertyName, attr, null, true, false);
    }

    public static void addRequiredPropertyReference(BeanDefinitionBuilder builder, String propertyName, Attr attr) {
        ParsingUtils.addProperty(builder, propertyName, attr, null, true, true);
    }

    public static void addPropertyValue(BeanDefinitionBuilder builder, String propertyName, Attr attr, String defaultValue, boolean required) {
        ParsingUtils.addProperty(builder, propertyName, attr, defaultValue, required, false);
    }

    public static void addPropertyReference(BeanDefinitionBuilder builder, String propertyName, Attr attr, String defaultValue, boolean required) {
        ParsingUtils.addProperty(builder, propertyName, attr, defaultValue, required, true);
    }

    public static void addProperty(BeanDefinitionBuilder builder, String propertyName, Attr attr, String defaultValue, boolean required, boolean reference) {
        Assert.notNull((Object)attr, (String)"Attr must not be null!");
        ParsingUtils.addProperty(builder, propertyName, attr.getValue(), defaultValue, required, reference);
    }

    public static void addRequiredPropertyValue(BeanDefinitionBuilder builder, String propertyName, String value) {
        ParsingUtils.addProperty(builder, propertyName, value, null, true, false);
    }

    public static void addRequiredPropertyReference(BeanDefinitionBuilder builder, String propertyName, String value) {
        ParsingUtils.addProperty(builder, propertyName, value, null, true, true);
    }

    public static void addOptionalPropertyValue(BeanDefinitionBuilder builder, String propertyName, String value, String defaultValue) {
        ParsingUtils.addProperty(builder, propertyName, value, defaultValue, false, false);
    }

    public static void addOptionalPropertyReference(BeanDefinitionBuilder builder, String propertyName, String value, String defaultValue) {
        ParsingUtils.addProperty(builder, propertyName, value, defaultValue, false, true);
    }

    public static void addPropertyValue(BeanDefinitionBuilder builder, String propertyName, String value, String defaultValue, boolean required) {
        ParsingUtils.addProperty(builder, propertyName, value, defaultValue, required, false);
    }

    public static void addPropertyReference(BeanDefinitionBuilder builder, String propertyName, String value, String defaultValue, boolean required) {
        ParsingUtils.addProperty(builder, propertyName, value, defaultValue, required, true);
    }

    public static void addProperty(BeanDefinitionBuilder builder, String propertyName, String value, String defaultValue, boolean required, boolean reference) {
        Assert.notNull((Object)builder, (String)"BeanDefinitionBuilder must not be null!");
        Assert.hasText((String)propertyName, (String)"Property name must not be null!");
        if (!StringUtils.hasText((String)value)) {
            if (required) {
                throw new IllegalStateException(String.format("value required for property %s [%s] on class [%s]", reference ? "reference" : "", propertyName, builder.getBeanDefinition().getClass().getName()));
            }
            if (defaultValue != null) {
                value = defaultValue;
            } else {
                return;
            }
        }
        if (reference) {
            builder.addPropertyReference(propertyName, value);
        } else {
            builder.addPropertyValue(propertyName, (Object)value);
        }
    }

    public static AbstractBeanDefinition getSourceBeanDefinition(BeanDefinitionBuilder builder, ParserContext context, Element element) {
        Assert.notNull((Object)element, (String)"Element must not be null!");
        Assert.notNull((Object)context, (String)"ParserContext must not be null!");
        return ParsingUtils.getSourceBeanDefinition(builder, context.extractSource((Object)element));
    }

    public static AbstractBeanDefinition getSourceBeanDefinition(BeanDefinitionBuilder builder, Object source) {
        Assert.notNull((Object)builder, (String)"Builder must not be null!");
        AbstractBeanDefinition definition = builder.getRawBeanDefinition();
        definition.setSource(source);
        return definition;
    }
}

